/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.network.type;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import electrodynamics.common.tile.pipelines.fluid.GenericTileFluidPipe;
import electrodynamics.common.tile.pipelines.fluid.TileFluidPipePump;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.network.ITickableNetwork;
import voltaic.api.network.cable.type.IFluidPipe;
import voltaic.common.network.NetworkRegistry;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.network.AbstractNetwork;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;

public class FluidNetwork
extends AbstractNetwork<GenericTileFluidPipe, IFluidPipe, FluidStack, FluidNetwork> {
    public HashMap<Integer, HashSet<TileFluidPipePump>> priorityPumpMap = new HashMap();

    public FluidNetwork(Collection<GenericTileFluidPipe> varCables) {
        this.conductorSet.addAll(varCables);
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public FluidNetwork(Set<FluidNetwork> networks) {
        for (FluidNetwork net : networks) {
            this.conductorSet.addAll(net.conductorSet);
            net.deregister();
        }
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public void refreshNewNetwork() {
        this.priorityPumpMap.clear();
        this.networkMaxTransfer = 0.0;
        super.refreshNewNetwork();
    }

    public FluidStack emit(FluidStack inserted, ArrayList<BlockEntity> ignored, boolean debug) {
        FluidStack transfer = new FluidStack(inserted.getFluid(), Math.min((int)this.networkMaxTransfer, inserted.getAmount()));
        if (transfer.getAmount() <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack initial = transfer.copy();
        FluidStack taken = new FluidStack(transfer.getFluid(), 0);
        Pair<FluidStack, Set<TileFluidPipePump>> priorityFilled = this.emitToPumps(transfer, ignored);
        initial.shrink(((FluidStack)priorityFilled.getFirst()).getAmount());
        taken.grow(((FluidStack)priorityFilled.getFirst()).getAmount());
        if (initial.isEmpty()) {
            return taken;
        }
        HashSet availableAcceptors = Sets.newHashSet();
        availableAcceptors.addAll(this.acceptorSet);
        availableAcceptors.removeAll(ignored);
        if (((Set)priorityFilled.getSecond()).size() > 0) {
            availableAcceptors.removeAll((Collection)priorityFilled.getSecond());
        }
        if (availableAcceptors.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int size = availableAcceptors.size();
        for (BlockEntity tile : availableAcceptors) {
            if (tile == null || tile.m_58901_()) {
                this.acceptorInputMap.remove(tile);
                this.acceptorSet.remove(tile);
                continue;
            }
            FluidStack perTile = new FluidStack(initial.getFluid(), (int)((double)initial.getAmount() / (double)size));
            FluidStack prePerTile = perTile.copy();
            HashSet connections = this.acceptorInputMap.getOrDefault(tile, new HashSet());
            int connectionsSize = connections.size();
            for (Direction dir : connections) {
                FluidStack perConnection = new FluidStack(initial.getFluid(), (int)((double)perTile.getAmount() / (double)connectionsSize));
                FluidStack prePerConnection = perConnection.copy();
                int amtTaken = FluidUtilities.receiveFluid((BlockEntity)tile, (Direction)dir, (FluidStack)perConnection, (boolean)false);
                perConnection.shrink(amtTaken);
                perTile.shrink(prePerConnection.getAmount() - perConnection.getAmount());
                --connectionsSize;
            }
            int takenAmt = prePerTile.getAmount() - perTile.getAmount();
            initial.shrink(takenAmt);
            taken.grow(takenAmt);
            --size;
        }
        return taken;
    }

    private Pair<FluidStack, Set<TileFluidPipePump>> emitToPumps(FluidStack transfer, ArrayList<BlockEntity> ignored) {
        FluidStack taken = new FluidStack(transfer.getFluid(), 0);
        HashSet acceptedPumps = new HashSet();
        if (this.priorityPumpMap.isEmpty()) {
            return Pair.of((Object)taken, acceptedPumps);
        }
        FluidStack copy = transfer.copy();
        for (int i = 9; i >= 0; --i) {
            if (copy.isEmpty()) {
                return Pair.of((Object)taken, acceptedPumps);
            }
            Set prioritySet = this.priorityPumpMap.getOrDefault(i, new HashSet());
            if (prioritySet.isEmpty()) continue;
            Pair<FluidStack, Set<TileFluidPipePump>> accepted = this.emitToPumpSet(copy, prioritySet, ignored);
            acceptedPumps.addAll((Collection)accepted.getSecond());
            taken.grow(((FluidStack)accepted.getFirst()).getAmount());
            copy.shrink(((FluidStack)accepted.getFirst()).getAmount());
        }
        return Pair.of((Object)taken, acceptedPumps);
    }

    private Pair<FluidStack, Set<TileFluidPipePump>> emitToPumpSet(FluidStack transfer, Set<TileFluidPipePump> recievingTiles, ArrayList<BlockEntity> ignored) {
        FluidStack initial = transfer.copy();
        FluidStack taken = new FluidStack(transfer.getFluid(), 0);
        HashSet<TileFluidPipePump> filledPumps = new HashSet<TileFluidPipePump>();
        int size = recievingTiles.size();
        for (TileFluidPipePump tile : recievingTiles) {
            if (!tile.isPowered() || ignored.contains((Object)tile)) {
                --size;
                continue;
            }
            FluidStack perTile = new FluidStack(initial.getFluid(), initial.getAmount() / size);
            FluidStack prePerTile = perTile.copy();
            HashSet connections = this.acceptorInputMap.getOrDefault((Object)tile, new HashSet());
            int connectionsSize = connections.size();
            for (Direction dir : connections) {
                FluidStack perConnection = new FluidStack(initial.getFluid(), perTile.getAmount() / connectionsSize);
                FluidStack prePerConnection = perConnection.copy();
                int amtTaken = FluidUtilities.receiveFluid((BlockEntity)tile, (Direction)dir, (FluidStack)perConnection, (boolean)false);
                perConnection.shrink(amtTaken);
                perTile.shrink(prePerConnection.getAmount() - perConnection.getAmount());
                --connectionsSize;
            }
            int takenAmt = prePerTile.getAmount() - perTile.getAmount();
            initial.shrink(takenAmt);
            taken.grow(takenAmt);
            filledPumps.add(tile);
            --size;
        }
        return Pair.of((Object)taken, filledPumps);
    }

    public void updateRecieverStatistics(BlockEntity reciever, Direction dir) {
        if (reciever instanceof TileFluidPipePump) {
            TileFluidPipePump pump = (TileFluidPipePump)reciever;
            int priority = (Integer)pump.priority.getValue();
            HashSet<TileFluidPipePump> set = this.priorityPumpMap.getOrDefault(priority, new HashSet());
            set.add(pump);
            this.priorityPumpMap.put(priority, set);
        }
    }

    public void updateFluidPipePumpStats(TileFluidPipePump changedPump, int newPriority, int prevPriority) {
        HashSet oldSet = this.priorityPumpMap.getOrDefault(prevPriority, new HashSet());
        oldSet.remove((Object)changedPump);
        this.priorityPumpMap.put(prevPriority, oldSet);
        HashSet<TileFluidPipePump> newSet = this.priorityPumpMap.getOrDefault(newPriority, new HashSet());
        newSet.add(changedPump);
        this.priorityPumpMap.put(newPriority, newSet);
    }

    public void updateConductorStatistics(GenericTileFluidPipe cable, boolean remove) {
        super.updateConductorStatistics((GenericRefreshingConnectTile)cable, remove);
        if (!remove && (this.networkMaxTransfer == 0.0 || (double)((IFluidPipe)cable.getCableType()).getMaxTransfer() < this.networkMaxTransfer)) {
            this.networkMaxTransfer = ((IFluidPipe)cable.getCableType()).getMaxTransfer();
        }
    }

    public void resetConductorStatistics() {
        this.networkMaxTransfer = 0.0;
        super.resetConductorStatistics();
    }

    public void resetReceiverStatistics() {
        this.priorityPumpMap.clear();
        super.resetReceiverStatistics();
    }

    public boolean isConductor(BlockEntity tile, GenericTileFluidPipe requsterCable) {
        return tile instanceof GenericTileFluidPipe;
    }

    public FluidNetwork createInstanceConductor(Set<GenericTileFluidPipe> conductors) {
        return new FluidNetwork((Collection<GenericTileFluidPipe>)conductors);
    }
}

