/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.packet.types.client;

import electrodynamics.common.packet.types.client.ClientBarrierMethods;
import electrodynamics.prefab.utilities.object.CombustionFuelSource;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketSetClientCombustionFuel {
    private final HashSet<CombustionFuelSource> fuels;

    public PacketSetClientCombustionFuel(HashSet<CombustionFuelSource> fuels) {
        this.fuels = fuels;
    }

    public static void handle(PacketSetClientCombustionFuel message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handlerClientCombustionFuels(message.fuels));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetClientCombustionFuel pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.fuels.size());
        for (CombustionFuelSource source : pkt.fuels) {
            source.writeToBuffer(buf);
        }
    }

    public static PacketSetClientCombustionFuel decode(FriendlyByteBuf buf) {
        int count = buf.readInt();
        HashSet<CombustionFuelSource> fuels = new HashSet<CombustionFuelSource>();
        for (int i = 0; i < count; ++i) {
            fuels.add(CombustionFuelSource.readFromBuffer(buf));
        }
        return new PacketSetClientCombustionFuel(fuels);
    }
}

