/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCircuitMonitor;
import electrodynamics.common.network.type.ElectricNetwork;
import electrodynamics.common.tile.electricitygrid.GenericTileWire;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileCircuitMonitor
extends GenericTile {
    public final SingleProperty<Integer> networkProperty = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "networkproperty", (Object)0));
    public final SingleProperty<Integer> booleanOperator = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "booleanoperator", (Object)0));
    public final SingleProperty<Double> value = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "value", (Object)0.0));
    public final SingleProperty<Boolean> redstoneSignal = (SingleProperty)this.property((AbstractProperty)((SingleProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false).onChange((prop, old) -> {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (old ^ (Boolean)prop.getValue()) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }).setNoUpdateClient()));
    protected CachedTileOutput output;

    public TileCircuitMonitor(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CIRCUITMONITOR.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, false).voltage(-1.0).receivePower((transfer, debug) -> TransferPack.EMPTY).getConnectedLoad((profile, dir) -> TransferPack.EMPTY).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.circuitmonitor.tag(), (GenericTile)this).createMenu((id, inv) -> new ContainerCircuitMonitor((int)id, (Inventory)inv, (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        double monitoredValue = this.getMonitoredValue(tickable.getTicks());
        if (monitoredValue < 0.0) {
            this.redstoneSignal.setValue((Object)false);
            return;
        }
        this.redstoneSignal.setValue((Object)this.performCheck(monitoredValue));
    }

    public int getSignal(Direction dir) {
        return this.getDirectSignal(dir);
    }

    public int getDirectSignal(Direction dir) {
        return (Boolean)this.redstoneSignal.getValue() != false ? 15 : 0;
    }

    public double getMonitoredValue(long ticks) {
        Object object;
        Direction facing = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (ticks % 40L == 0L) {
            this.output.update(this.f_58858_.m_121945_(facing));
        }
        if (this.output.valid() && (object = this.output.getSafe()) instanceof GenericTileWire) {
            GenericTileWire wire = (GenericTileWire)((Object)object);
            ElectricNetwork network = (ElectricNetwork)wire.getNetwork();
            return switch ((Integer)this.networkProperty.getValue()) {
                case 0 -> network.getActiveTransmitted() / 20.0;
                case 1 -> network.getActiveVoltage();
                case 2 -> network.getAmpacity();
                case 3 -> network.getMinimumVoltage();
                case 4 -> network.getResistance();
                case 5 -> network.getMaxJoulesStored() / 20.0;
                default -> -1.0;
            };
        }
        return -1.0;
    }

    public boolean performCheck(double monitoredValue) {
        return switch ((Integer)this.booleanOperator.getValue()) {
            case 0 -> {
                if (monitoredValue == (Double)this.value.getValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (monitoredValue != (Double)this.value.getValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (monitoredValue < (Double)this.value.getValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (monitoredValue > (Double)this.value.getValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (monitoredValue <= (Double)this.value.getValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (monitoredValue >= (Double)this.value.getValue()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

