/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerChemicalCrystallizer;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericMaterialTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileChemicalCrystallizer
extends GenericMaterialTile
implements ITickableSound {
    public static final int MAX_TANK_CAPACITY = 5000;
    private boolean isSoundPlaying = false;

    public TileChemicalCrystallizer(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CHEMICALCRYSTALLIZER.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(240.0));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(1, new int[]{5000}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).setRecipeType((RecipeType)ElectrodynamicsRecipies.CHEMICAL_CRYSTALIZER_TYPE.get()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 0, 1, 0).bucketInputs(1).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.FRONT}).validUpgrades(ContainerChemicalCrystallizer.VALID_UPGRADES).valid(TileChemicalCrystallizer.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess((component, procNumber) -> component.consumeBucket().canProcessFluid2ItemRecipe(procNumber.intValue(), (RecipeType)ElectrodynamicsRecipies.CHEMICAL_CRYSTALIZER_TYPE.get())).process(ComponentProcessor::processFluid2ItemRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.chemicalcrystallizer.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerChemicalCrystallizer((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.shouldPlaySound()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            Direction direction = this.getFacing();
            double d4 = this.f_58857_.f_46441_.m_188500_();
            double d5 = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : d4;
            double d6 = this.f_58857_.f_46441_.m_188500_();
            double d7 = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : d4;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + d5, (double)this.f_58858_.m_123342_() + d6, (double)this.f_58858_.m_123343_() + d7, 0.0, 0.0, 0.0);
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

