/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.mineralcrusher;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.particle.ParticleAPI;
import voltaic.common.inventory.container.ContainerO2OProcessor;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileMineralCrusher
extends GenericTile
implements ITickableSound {
    private final int procCount;
    public long clientRunningTicks = 0L;
    private boolean isSoundPlaying = false;

    public TileMineralCrusher(BlockPos pos, BlockState state) {
        this((BlockEntityType)ElectrodynamicsTiles.TILE_MINERALCRUSHER.get(), 1, pos, state);
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.mineralcrusher.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerO2OProcessor(id.intValue(), player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public TileMineralCrusher(BlockEntityType<?> type, int procCount, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.procCount = procCount;
        int inputsPerProc = 1;
        int outputPerProc = 1;
        int biprodsPerProc = 1;
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(240.0 * Math.pow(2.0, procCount - 1)));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(procCount, inputsPerProc, outputPerProc, biprodsPerProc).upgrades(3)).validUpgrades(ContainerO2OProcessor.VALID_UPGRADES).valid(TileMineralCrusher.machineValidator()).implementMachineInputsAndOutputs());
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this, procCount).canProcess((component, procNumber) -> component.canProcessItem2ItemRecipe(procNumber.intValue(), (RecipeType)ElectrodynamicsRecipies.MINERAL_CRUSHER_TYPE.get())).process(ComponentProcessor::processItem2ItemRecipe));
    }

    protected void tickClient(ComponentTickable tickable) {
        double progress;
        if (!((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive()) {
            return;
        }
        Direction direction = this.getFacing();
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            double d4 = this.f_58857_.f_46441_.m_188500_();
            double d5 = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : d4;
            double d6 = this.f_58857_.f_46441_.m_188500_();
            double d7 = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : d4;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + d5, (double)this.f_58858_.m_123342_() + d6, (double)this.f_58858_.m_123343_() + d7, 0.0, 0.0, 0.0);
        }
        if ((progress = Math.sin(0.15707963267948966 * (double)(this.clientRunningTicks % 20L))) < 0.3) {
            for (int i = 0; i < 5; ++i) {
                double d4 = this.f_58857_.f_46441_.m_188500_() * 4.0 / 16.0 + 0.5 - 0.125;
                double d6 = this.f_58857_.f_46441_.m_188500_() * 4.0 / 16.0 + 0.5 - 0.125;
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + d4 + (double)direction.m_122429_() * 0.2, (double)this.f_58858_.m_123342_() + 0.4, (double)this.f_58858_.m_123343_() + d6 + (double)direction.m_122431_() * 0.2, 0.0, 0.0, 0.0);
            }
            for (int procNum = 0; procNum < this.procCount; ++procNum) {
                ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
                ItemStack stack = (ItemStack)inv.getInputsForProcessor(procNum).get(0);
                Item d7 = stack.m_41720_();
                if (!(d7 instanceof BlockItem)) continue;
                BlockItem it = (BlockItem)d7;
                Block block = it.m_40614_();
                for (int i = 0; i < 5; ++i) {
                    double d4 = this.f_58857_.f_46441_.m_188500_() * 4.0 / 16.0 + 0.5 - 0.125;
                    double d6 = this.f_58857_.f_46441_.m_188500_() * 4.0 / 16.0 + 0.5 - 0.125;
                    ParticleAPI.addGrindedParticle((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + d4 + (double)direction.m_122429_() * 0.2), (double)((double)this.f_58858_.m_123342_() + 0.4), (double)((double)this.f_58858_.m_123343_() + d6 + (double)direction.m_122431_() * 0.2), (double)0.0, (double)0.0, (double)0.0, (BlockState)block.m_49966_(), (BlockPos)this.f_58858_);
                }
            }
        }
        ++this.clientRunningTicks;
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_MINERALCRUSHER.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive();
    }

    public int getComparatorSignal() {
        return (int)((double)((ComponentProcessor)this.getComponent(IComponentType.Processor)).getTotalActive() / (double)Math.max(1, ((ComponentProcessor)this.getComponent(IComponentType.Processor)).getProcessorCount()) * 15.0);
    }
}

