/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.quarry;

import com.mojang.authlib.GameProfile;
import electrodynamics.client.event.levelstage.HandlerQuarryArm;
import electrodynamics.common.block.BlockFrame;
import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerQuarry;
import electrodynamics.common.item.ItemDrillHead;
import electrodynamics.common.item.subtype.SubtypeDrillHead;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.machines.quarry.QuarryRenderManger;
import electrodynamics.common.tile.machines.quarry.TileCoolantResavoir;
import electrodynamics.common.tile.machines.quarry.TileFrame;
import electrodynamics.common.tile.machines.quarry.TileMotorComplex;
import electrodynamics.common.tile.machines.quarry.TileSeismicRelay;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import voltaic.api.tile.IPlayerStorable;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.block.GenericMachineBlock;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.ItemUtils;

public class TileQuarry
extends GenericTile
implements IPlayerStorable {
    private static final int CAPACITY = 10000;
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final int CLEAR_SKIP = Math.max(Math.min(ElectroConstants.CLEARING_AIR_SKIP, 128), 0);
    public static final int DRILL_HEAD_INDEX = 0;
    @Nullable
    private UUID placedBy = null;
    public final SingleProperty<Boolean> hasCoolantResavoir = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hascoolantresavoir", (Object)false));
    public final SingleProperty<Boolean> hasMotorComplex = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasmotorcomplex", (Object)false));
    public final SingleProperty<Boolean> hasSeismicRelay = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasseismicrelay", (Object)false));
    public final SingleProperty<Boolean> hasRing = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasring", (Object)false));
    private TileMotorComplex complex = null;
    private TileCoolantResavoir resavoir = null;
    private TileSeismicRelay relay = null;
    private boolean hasBottomStrip = false;
    private boolean hasTopStrip = false;
    private boolean hasLeftStrip = false;
    private boolean hasRightStrip = false;
    private BlockPos currPos = null;
    private BlockPos prevPos = null;
    private boolean prevIsCorner = false;
    private boolean lastIsCorner = false;
    private final HashMap<BlockPos, BlockState> brokenFrames = new HashMap();
    private final HashSet<BlockPos> repairedFrames = new HashSet();
    public final ListProperty<BlockPos> corners = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.BLOCK_POS_LIST, "corners", List.of(BlockEntityUtils.OUT_OF_REACH, BlockEntityUtils.OUT_OF_REACH, BlockEntityUtils.OUT_OF_REACH, BlockEntityUtils.OUT_OF_REACH)));
    public final SingleProperty<Boolean> cornerOnRight = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "corneronright", (Object)false));
    private boolean hasHandledDecay = false;
    public final SingleProperty<Boolean> isAreaCleared = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "areaClear", (Object)false));
    private int heightShiftCA = 0;
    private int widthShiftCA = 0;
    private int tickDelayCA = 0;
    private int widthShiftCR = 0;
    private int lengthShiftMiner = 0;
    private int heightShiftMiner = 1;
    private int widthShiftMiner = 0;
    private int tickDelayMiner = 0;
    public final SingleProperty<BlockPos> miningPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "miningpos", (Object)BlockEntityUtils.OUT_OF_REACH));
    public final SingleProperty<BlockPos> prevMiningPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "prevminingpos", (Object)BlockEntityUtils.OUT_OF_REACH));
    public final SingleProperty<Boolean> isFinished = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isfinished", (Object)false));
    private boolean widthReverse = false;
    private boolean lengthReverse = false;
    public final SingleProperty<Double> quarryPowerUsage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "quarrypowerusage", (Object)0.0));
    public final SingleProperty<Double> setupPowerUsage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "setuppowerusage", (Object)0.0));
    public final SingleProperty<Boolean> isPowered = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "ispowered", (Object)false));
    public final SingleProperty<Boolean> hasHead = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hashead", (Object)false));
    public final SingleProperty<Integer> currHead = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "headtype", (Object)-1));
    public final SingleProperty<Boolean> hasItemVoid = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasitemvoid", (Object)false));
    public final SingleProperty<Integer> fortuneLevel = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortunelevel", (Object)0));
    public final SingleProperty<Integer> silkTouchLevel = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "silktouchlevel", (Object)0));
    public final SingleProperty<Integer> unbreakingLevel = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "unbreakinglevel", (Object)0));
    public final SingleProperty<Integer> speed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "speed", (Object)0));
    public final SingleProperty<Integer> progressCounter = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "progresscounter", (Object)0));
    public final SingleProperty<Boolean> running = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isrunning", (Object)false));
    public final SingleProperty<Boolean> isTryingToMineFrame = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "istryingtomineframe", (Object)false));
    private int widthShiftMaintainMining = 0;
    private boolean cont = false;
    private QuarryRenderManger renderHandler = null;

    public TileQuarry(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_QUARRY.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(240.0).maxJoules(ElectroConstants.QUARRY_USAGE_PER_TICK * 10000.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(7).outputs(9).upgrades(3)).validUpgrades(ContainerQuarry.VALID_UPGRADES).valid(TileQuarry.machineValidator()).setSlotsByDirection(BlockEntityUtils.MachineDirection.FRONT, new Integer[]{0, 7, 8, 9, 10, 11, 12, 13, 14, 15}));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.quarry.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerQuarry((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tick) {
        if (((Boolean)this.isFinished.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            if (!this.hasHandledDecay) {
                this.handleFramesDecay();
                this.hasHandledDecay = true;
            }
            return;
        }
        this.speed.setValue((Object)(this.complex == null ? 0 : (Integer)this.complex.speed.getValue() + this.tickDelayMiner));
        BlockPos pos = this.m_58899_();
        if (GenericMachineBlock.IPLAYERSTORABLE_MAP.containsKey(pos)) {
            this.setPlayer((LivingEntity)GenericMachineBlock.IPLAYERSTORABLE_MAP.get(pos));
            GenericMachineBlock.IPLAYERSTORABLE_MAP.remove(pos);
        }
        if ((tick.getTicks() + 1L) % 5L == 0L) {
            this.checkComponents();
        }
        if (!((Boolean)this.hasSeismicRelay.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            if (this.hasCorners() && !this.hasHandledDecay && ((Boolean)this.isAreaCleared.getValue()).booleanValue()) {
                this.handleFramesDecay();
            }
            return;
        }
        if (!((Boolean)this.hasSeismicRelay.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            return;
        }
        if (!((Boolean)this.hasRing.getValue()).booleanValue() && tick.getTicks() % (long)(3 + this.tickDelayCA) == 0L && !((Boolean)this.isFinished.getValue()).booleanValue()) {
            if (((Boolean)this.isAreaCleared.getValue()).booleanValue()) {
                this.checkRing();
            } else {
                this.clearArea();
            }
        }
        if (!((Boolean)this.hasRing.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            return;
        }
        Level world = this.m_58904_();
        if (tick.getTicks() % 4L == 0L) {
            this.cleanRing();
        }
        if (!this.brokenFrames.isEmpty()) {
            this.handleBrokenFrames();
        }
        if (!this.repairedFrames.isEmpty()) {
            this.handleRepairedFrames();
        }
        if (this.areComponentsNull()) {
            this.running.setValue((Object)false);
            return;
        }
        if (tick.getTicks() % 4L == 0L && ElectroConstants.MAINTAIN_MINING_AREA) {
            this.maintainMiningArea();
        }
        boolean shouldFail = false;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.isPowered.setValue((Object)(electro.getJoulesStored() >= (Double)this.quarryPowerUsage.getValue() ? 1 : 0));
        if (!((Boolean)this.isPowered.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            shouldFail = true;
        }
        if (!((Boolean)this.complex.isPowered.getValue()).booleanValue() || (Integer)this.complex.speed.getValue() <= 0) {
            this.running.setValue((Object)false);
            shouldFail = true;
        }
        int fluidUse = (int)((Double)this.complex.powerMultiplier.getValue() * (double)ElectroConstants.QUARRY_WATERUSAGE_PER_BLOCK);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        Item item = inv.m_8020_(0).m_41720_();
        if (item instanceof ItemDrillHead) {
            ItemDrillHead head = (ItemDrillHead)item;
            this.hasHead.setValue((Object)true);
            this.writeHeadType(head.head);
        } else {
            this.hasHead.setValue((Object)false);
            this.writeHeadType(null);
            this.running.setValue((Object)false);
        }
        if (shouldFail) {
            return;
        }
        if (!(inv.areOutputsEmpty() && this.resavoir.hasEnoughFluid(fluidUse) && ((Boolean)this.hasHead.getValue()).booleanValue())) {
            this.running.setValue((Object)false);
            return;
        }
        this.running.setValue((Object)true);
        this.progressCounter.setValue((Object)((Integer)this.progressCounter.getValue() + 1));
        if ((Integer)this.progressCounter.getValue() < (Integer)this.speed.getValue()) {
            return;
        }
        this.progressCounter.setValue((Object)0);
        if (this.canMineIfFrame(world.m_8055_((BlockPos)this.miningPos.getValue()), (BlockPos)this.miningPos.getValue())) {
            this.isTryingToMineFrame.setValue((Object)true);
            return;
        }
        this.isTryingToMineFrame.setValue((Object)false);
        this.resavoir.drainFluid(fluidUse);
        BlockPos cornerStart = (BlockPos)((List)this.corners.getValue()).get(3);
        BlockPos cornerEnd = (BlockPos)((List)this.corners.getValue()).get(0);
        int deltaW = (int)Math.signum(cornerStart.m_123341_() - cornerEnd.m_123341_());
        int deltaL = (int)Math.signum(cornerStart.m_123343_() - cornerEnd.m_123343_());
        int width = cornerStart.m_123341_() - cornerEnd.m_123341_() - 2 * deltaW;
        int length = cornerStart.m_123343_() - cornerEnd.m_123343_() - 2 * deltaL;
        this.cont = true;
        if (!((BlockPos)this.miningPos.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
            BlockState miningState = world.m_8055_((BlockPos)this.miningPos.getValue());
            float strength = miningState.m_60800_((BlockGetter)world, (BlockPos)this.miningPos.getValue());
            if (!this.skipBlock(miningState) && strength >= 0.0f) {
                this.cont = this.mineBlock((BlockPos)this.miningPos.getValue(), miningState, strength, world, inv.m_8020_(0), inv, (Player)this.getPlayer((ServerLevel)world));
            }
        }
        this.prevMiningPos.setValue((Object)new BlockPos((Vec3i)this.miningPos.getValue()));
        this.miningPos.setValue((Object)new BlockPos(cornerStart.m_123341_() - this.widthShiftMiner - deltaW, cornerStart.m_123342_() - this.heightShiftMiner, cornerStart.m_123343_() - this.lengthShiftMiner - deltaL));
        BlockState state = world.m_8055_((BlockPos)this.miningPos.getValue());
        boolean shouldSkip = true;
        if (!this.cont) {
            return;
        }
        while (shouldSkip) {
            if (((BlockPos)this.miningPos.getValue()).m_123342_() <= world.m_141937_()) {
                this.heightShiftMiner = 1;
                this.isFinished.setValue((Object)true);
                this.progressCounter.setValue((Object)0);
                this.running.setValue((Object)false);
                break;
            }
            if (this.lengthReverse ? this.lengthShiftMiner == 0 : this.lengthShiftMiner == length) {
                boolean bl = this.lengthReverse = !this.lengthReverse;
                if (this.widthReverse ? this.widthShiftMiner == 0 : this.widthShiftMiner == width) {
                    this.widthReverse = !this.widthReverse;
                    ++this.heightShiftMiner;
                } else {
                    this.widthShiftMiner = this.widthReverse ? (this.widthShiftMiner -= deltaW) : (this.widthShiftMiner += deltaW);
                }
            } else {
                this.lengthShiftMiner = this.lengthReverse ? (this.lengthShiftMiner -= deltaL) : (this.lengthShiftMiner += deltaL);
            }
            this.miningPos.setValue((Object)new BlockPos(cornerStart.m_123341_() - this.widthShiftMiner - deltaW, cornerStart.m_123342_() - this.heightShiftMiner, cornerStart.m_123343_() - this.lengthShiftMiner - deltaL));
            state = world.m_8055_((BlockPos)this.miningPos.getValue());
            shouldSkip = this.skipBlock(state);
        }
        float strength = state.m_60800_((BlockGetter)world, (BlockPos)this.miningPos.getValue());
        this.tickDelayMiner = (int)strength;
        if (!shouldSkip && strength >= 0.0f) {
            electro.joules(electro.getJoulesStored() - (Double)this.quarryPowerUsage.getValue());
        }
        if (shouldSkip) {
            if (this.lengthReverse ? this.lengthShiftMiner == 0 : this.lengthShiftMiner == length) {
                boolean bl = this.lengthReverse = !this.lengthReverse;
                if (this.widthReverse ? this.widthShiftMiner == 0 : this.widthShiftMiner == width) {
                    this.widthReverse = !this.widthReverse;
                    ++this.heightShiftMiner;
                    if (((BlockPos)this.miningPos.getValue()).m_123342_() <= world.m_141937_()) {
                        this.heightShiftMiner = 1;
                        this.isFinished.setValue((Object)true);
                        this.progressCounter.setValue((Object)0);
                        this.running.setValue((Object)false);
                    }
                } else {
                    this.widthShiftMiner = this.widthReverse ? (this.widthShiftMiner -= deltaW) : (this.widthShiftMiner += deltaW);
                }
            } else {
                this.lengthShiftMiner = this.lengthReverse ? (this.lengthShiftMiner -= deltaL) : (this.lengthShiftMiner += deltaL);
            }
        }
    }

    public void addBrokenFrame(BlockPos frame, BlockState frameState) {
        this.brokenFrames.put(frame, frameState);
    }

    private void maintainMiningArea() {
        Level world = this.m_58904_();
        BlockPos cornerStart = (BlockPos)((List)this.corners.getValue()).get(3);
        BlockPos cornerEnd = (BlockPos)((List)this.corners.getValue()).get(0);
        int deltaW = (int)Math.signum(cornerStart.m_123341_() - cornerEnd.m_123341_());
        int deltaL = (int)Math.signum(cornerStart.m_123343_() - cornerEnd.m_123343_());
        int width = cornerStart.m_123341_() - cornerEnd.m_123341_() - 2 * deltaW;
        int length = cornerStart.m_123343_() - cornerEnd.m_123343_();
        BlockPos startPos = new BlockPos(cornerStart.m_123341_() - this.widthShiftMaintainMining - deltaW, cornerStart.m_123342_(), cornerStart.m_123343_() - deltaL);
        BlockPos endPos = new BlockPos(cornerStart.m_123341_() - this.widthShiftMaintainMining - deltaW, ((BlockPos)this.miningPos.getValue()).m_123342_() + 1, cornerStart.m_123343_() - length + deltaL);
        Iterator positions = BlockPos.m_121990_((BlockPos)startPos, (BlockPos)endPos).iterator();
        while (positions.hasNext()) {
            BlockPos pos = (BlockPos)positions.next();
            BlockState state = world.m_8055_(pos);
            if (this.skipBlock(state)) continue;
            int newWidthShift = -1 * (pos.m_123341_() - (cornerStart.m_123341_() - deltaW));
            int newLengthShift = -1 * (pos.m_123343_() - (cornerStart.m_123343_() - deltaL));
            this.widthShiftMiner = newWidthShift;
            this.lengthShiftMiner = newLengthShift;
            this.widthShiftMaintainMining = 0;
            this.heightShiftMiner = startPos.m_123342_() - pos.m_123342_() - 1;
            this.prevMiningPos.setValue((Object)new BlockPos((Vec3i)this.miningPos.getValue()));
            this.miningPos.setValue((Object)pos);
            this.widthReverse = false;
            this.lengthReverse = false;
            this.progressCounter.setValue((Object)0);
            return;
        }
        this.widthShiftMaintainMining = this.widthShiftMaintainMining == width ? 0 : (this.widthShiftMaintainMining += deltaW);
    }

    private void cleanRing() {
        Level world = this.m_58904_();
        BlockPos cornerStart = (BlockPos)((List)this.corners.getValue()).get(3);
        BlockPos cornerEnd = (BlockPos)((List)this.corners.getValue()).get(0);
        int deltaW = (int)Math.signum(cornerStart.m_123341_() - cornerEnd.m_123341_());
        int deltaL = (int)Math.signum(cornerStart.m_123343_() - cornerEnd.m_123343_());
        int width = cornerStart.m_123341_() - cornerEnd.m_123341_() - 2 * deltaW;
        int length = cornerStart.m_123343_() - cornerEnd.m_123343_();
        BlockPos startPos = new BlockPos(cornerStart.m_123341_() - this.widthShiftCR - deltaW, cornerStart.m_123342_(), cornerStart.m_123343_() - deltaL);
        BlockPos endPos = new BlockPos(cornerStart.m_123341_() - this.widthShiftCR - deltaW, cornerStart.m_123342_(), cornerStart.m_123343_() - length + deltaL);
        Stream positions = BlockPos.m_121990_((BlockPos)startPos, (BlockPos)endPos);
        positions.forEach(pos -> {
            BlockState state = world.m_8055_(pos);
            if (!this.skipBlock(state)) {
                boolean canMine;
                boolean bl = canMine = world.m_46953_(pos, false, (Entity)this.getPlayer((ServerLevel)world)) || ElectroConstants.BYPASS_CLAIMS;
                if (canMine) {
                    world.m_46597_(pos, AIR);
                    world.m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            }
        });
        this.widthShiftCR = this.widthShiftCR == width ? 0 : (this.widthShiftCR += deltaW);
    }

    private boolean mineBlock(BlockPos pos, BlockState state, float strength, Level world, ItemStack drillHead, ComponentInventory inv, Player player) {
        boolean sucess = world.m_46953_(pos, false, (Entity)player);
        if (sucess) {
            SubtypeDrillHead head = ((ItemDrillHead)drillHead.m_41720_()).head;
            if (!head.isUnbreakable) {
                int durabilityUsed = (int)(Math.ceil(strength) / (double)((float)((Integer)this.unbreakingLevel.getValue()).intValue() + 1.0f));
                if (drillHead.m_41773_() + durabilityUsed >= drillHead.m_41776_()) {
                    world.m_5594_(null, this.m_58899_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    drillHead.m_41774_(1);
                } else {
                    drillHead.m_41721_(drillHead.m_41773_() + durabilityUsed);
                }
            }
            ItemStack pickaxe = new ItemStack((ItemLike)Items.f_42395_);
            if ((Integer)this.silkTouchLevel.getValue() > 0) {
                pickaxe.m_41663_(Enchantments.f_44985_, ((Integer)this.silkTouchLevel.getValue()).intValue());
            } else if ((Integer)this.fortuneLevel.getValue() > 0) {
                pickaxe.m_41663_(Enchantments.f_44987_, ((Integer)this.fortuneLevel.getValue()).intValue());
            }
            List lootItems = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, null, (ItemStack)pickaxe);
            List voidItemStacks = inv.getInputContents().subList(1, inv.getInputContents().size());
            ArrayList voidItems = new ArrayList();
            voidItemStacks.forEach(h -> voidItems.add(h.m_41720_()));
            ArrayList items = new ArrayList();
            if (((Boolean)this.hasItemVoid.getValue()).booleanValue()) {
                lootItems.forEach(lootItem -> {
                    if (!voidItems.contains(lootItem.m_41720_())) {
                        items.add(lootItem);
                    }
                });
            } else {
                items.addAll(lootItems);
            }
            int max = inv.getOutputStartIndex() + inv.getOutputContents().size();
            block0: for (ItemStack item : items) {
                for (int i = inv.getOutputStartIndex(); i < max; ++i) {
                    ItemStack contained = inv.m_8020_(i);
                    int room = contained.m_41741_() - contained.m_41613_();
                    int amtAccepted = Math.min(room, item.m_41613_());
                    if (amtAccepted == 0) continue;
                    if (contained.m_41619_()) {
                        inv.m_6836_(i, new ItemStack((ItemLike)item.m_41720_(), amtAccepted));
                        item.m_41774_(amtAccepted);
                    } else if (ItemUtils.testItems((Item)item.m_41720_(), (Item[])new Item[]{contained.m_41720_()})) {
                        contained.m_41769_(amtAccepted);
                        item.m_41774_(amtAccepted);
                        inv.m_6596_();
                    }
                    if (item.m_41619_()) continue block0;
                }
            }
            world.m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return sucess;
    }

    private void clearArea() {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.setupPowerUsage.setValue((Object)ElectroConstants.QUARRY_USAGE_PER_TICK);
        this.isPowered.setValue((Object)(electro.getJoulesStored() >= (Double)this.setupPowerUsage.getValue() ? 1 : 0));
        if (this.hasCorners() && ((Boolean)this.isPowered.getValue()).booleanValue()) {
            Level world = this.m_58904_();
            BlockPos start = (BlockPos)((List)this.corners.getValue()).get(3);
            BlockPos end = (BlockPos)((List)this.corners.getValue()).get(0);
            int width = start.m_123341_() - end.m_123341_();
            int height = start.m_123343_() - end.m_123343_();
            int deltaW = (int)Math.signum(width);
            int deltaH = (int)Math.signum(height);
            BlockPos checkPos = new BlockPos(start.m_123341_() - this.widthShiftCA, start.m_123342_(), start.m_123343_() - this.heightShiftCA);
            BlockState state = world.m_8055_(checkPos);
            if (this.canMineIfFrame(state, checkPos)) {
                this.isTryingToMineFrame.setValue((Object)true);
                return;
            }
            this.isTryingToMineFrame.setValue((Object)true);
            float strength = state.m_60800_((BlockGetter)world, checkPos);
            for (int blockSkip = 0; this.skipBlock(state) && blockSkip < CLEAR_SKIP; ++blockSkip) {
                if (this.heightShiftCA == height) {
                    this.heightShiftCA = 0;
                    if (this.widthShiftCA == width) {
                        this.isAreaCleared.setValue((Object)true);
                        this.widthShiftCA = 0;
                        this.tickDelayCA = 0;
                        return;
                    }
                    this.widthShiftCA += deltaW;
                } else {
                    this.heightShiftCA += deltaH;
                }
                checkPos = new BlockPos(start.m_123341_() - this.widthShiftCA, start.m_123342_(), start.m_123343_() - this.heightShiftCA);
                state = world.m_8055_(checkPos);
            }
            if (strength >= 0.0f && electro.getJoulesStored() >= (Double)this.setupPowerUsage.getValue() * (double)strength) {
                boolean sucess = false;
                if (!this.skipBlock(state)) {
                    this.tickDelayCA = (int)Math.ceil(strength / 5.0f);
                    electro.joules(electro.getJoulesStored() - (Double)this.setupPowerUsage.getValue() * (double)strength);
                    sucess = world.m_46953_(checkPos, false, (Entity)this.getPlayer((ServerLevel)world));
                    if (sucess) {
                        world.m_5594_(null, checkPos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                if (sucess) {
                    if (this.heightShiftCA == height) {
                        this.heightShiftCA = 0;
                        if (this.widthShiftCA == width) {
                            this.isAreaCleared.setValue((Object)true);
                            this.widthShiftCA = 0;
                            this.tickDelayCA = 0;
                        } else {
                            this.widthShiftCA += deltaW;
                        }
                    } else {
                        this.heightShiftCA += deltaH;
                    }
                }
            }
        }
    }

    private void handleBrokenFrames() {
        Level world = this.m_58904_();
        this.brokenFrames.forEach((pos, state) -> {
            world.m_46597_(pos, state);
            world.m_5594_(null, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.repairedFrames.add(new BlockPos((Vec3i)pos));
        });
        this.brokenFrames.clear();
        this.isChanged = true;
    }

    private void handleRepairedFrames() {
        Level world = this.m_58904_();
        Iterator<BlockPos> it = this.repairedFrames.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            BlockEntity entity = world.m_7702_(pos);
            if (entity == null || !(entity instanceof TileFrame)) continue;
            TileFrame frame = (TileFrame)entity;
            frame.setQuarryPos(this.m_58899_());
            it.remove();
        }
        this.isChanged = true;
    }

    private void checkRing() {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < ElectroConstants.QUARRY_USAGE_PER_TICK && this.hasCorners()) {
            return;
        }
        electro.joules(electro.getJoulesStored() - ElectroConstants.QUARRY_USAGE_PER_TICK);
        BlockState cornerState = (BlockState)((BlockFrame)((Object)ElectrodynamicsBlocks.BLOCK_FRAME_CORNER.get())).m_49966_().m_61124_((Property)VoltaicBlockStates.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Level world = this.m_58904_();
        BlockPos frontOfQuarry = (BlockPos)((List)this.corners.getValue()).get(0);
        BlockPos foqFar = (BlockPos)((List)this.corners.getValue()).get(1);
        BlockPos foqCorner = (BlockPos)((List)this.corners.getValue()).get(2);
        BlockPos farCorner = (BlockPos)((List)this.corners.getValue()).get(3);
        Direction facing = this.getFacing().m_122424_();
        if (this.prevPos != null && this.hasAllStrips()) {
            this.hasRing.setValue((Object)true);
            this.prevPos = null;
            this.isFinished.setValue((Object)false);
            this.heightShiftMiner = 1;
            this.widthShiftMiner = 0;
            this.lengthShiftMiner = 0;
            this.quarryPowerUsage.setValue((Object)0.0);
            this.setupPowerUsage.setValue((Object)0.0);
            BlockPos cornerStart = (BlockPos)((List)this.corners.getValue()).get(3);
            BlockPos cornerEnd = (BlockPos)((List)this.corners.getValue()).get(0);
            int deltaW = (int)Math.signum(cornerStart.m_123341_() - cornerEnd.m_123341_());
            int deltaL = (int)Math.signum(cornerStart.m_123343_() - cornerEnd.m_123343_());
            this.miningPos.setValue((Object)new BlockPos(cornerStart.m_123341_() - deltaW, cornerStart.m_123342_() - this.heightShiftMiner, cornerStart.m_123343_() - deltaL));
            this.prevMiningPos.setValue((Object)new BlockPos((Vec3i)this.miningPos.getValue()));
        }
        switch (facing) {
            case EAST: {
                if (!this.hasBottomStrip) {
                    this.stripWithCorners(world, foqCorner, frontOfQuarry, foqCorner.m_123343_(), frontOfQuarry.m_123343_(), Direction.SOUTH, Direction.EAST, cornerState, false, false);
                    return;
                }
                if (!this.hasTopStrip) {
                    this.stripWithCorners(world, farCorner, foqFar, farCorner.m_123343_(), foqFar.m_123343_(), Direction.SOUTH, Direction.WEST, cornerState, false, true);
                    return;
                }
                if (!this.hasLeftStrip) {
                    this.strip(world, foqCorner, farCorner.m_123341_(), Direction.EAST, Direction.SOUTH, true, true);
                    return;
                }
                if (this.hasRightStrip) break;
                this.strip(world, frontOfQuarry, foqFar.m_123341_(), Direction.EAST, Direction.NORTH, true, false);
                break;
            }
            case WEST: {
                if (!this.hasBottomStrip) {
                    this.stripWithCorners(world, foqCorner, frontOfQuarry, foqCorner.m_123343_(), frontOfQuarry.m_123343_(), Direction.NORTH, Direction.WEST, cornerState, false, false);
                    return;
                }
                if (!this.hasTopStrip) {
                    this.stripWithCorners(world, farCorner, foqFar, foqCorner.m_123343_(), frontOfQuarry.m_123343_(), Direction.NORTH, Direction.EAST, cornerState, false, true);
                    return;
                }
                if (!this.hasLeftStrip) {
                    this.strip(world, foqCorner, farCorner.m_123341_(), Direction.WEST, Direction.NORTH, true, true);
                    return;
                }
                if (this.hasRightStrip) break;
                this.strip(world, frontOfQuarry, foqFar.m_123341_(), Direction.WEST, Direction.SOUTH, true, false);
                break;
            }
            case SOUTH: {
                if (!this.hasBottomStrip) {
                    this.stripWithCorners(world, foqCorner, frontOfQuarry, foqCorner.m_123341_(), frontOfQuarry.m_123341_(), Direction.WEST, Direction.SOUTH, cornerState, true, false);
                    return;
                }
                if (!this.hasTopStrip) {
                    this.stripWithCorners(world, farCorner, foqFar, farCorner.m_123341_(), foqFar.m_123341_(), Direction.WEST, Direction.NORTH, cornerState, true, true);
                    return;
                }
                if (!this.hasLeftStrip) {
                    this.strip(world, foqCorner, farCorner.m_123343_(), Direction.SOUTH, Direction.WEST, false, true);
                    return;
                }
                if (this.hasRightStrip) break;
                this.strip(world, frontOfQuarry, foqFar.m_123343_(), Direction.SOUTH, Direction.EAST, false, false);
                break;
            }
            case NORTH: {
                if (!this.hasBottomStrip) {
                    this.stripWithCorners(world, foqCorner, frontOfQuarry, foqCorner.m_123341_(), frontOfQuarry.m_123341_(), Direction.EAST, Direction.NORTH, cornerState, true, false);
                    return;
                }
                if (!this.hasTopStrip) {
                    this.stripWithCorners(world, farCorner, foqFar, farCorner.m_123341_(), foqFar.m_123341_(), Direction.EAST, Direction.SOUTH, cornerState, true, true);
                    return;
                }
                if (!this.hasLeftStrip) {
                    this.strip(world, foqCorner, farCorner.m_123343_(), Direction.NORTH, Direction.EAST, false, true);
                    return;
                }
                if (this.hasRightStrip) break;
                this.strip(world, frontOfQuarry, foqFar.m_123343_(), Direction.NORTH, Direction.WEST, false, false);
                break;
            }
        }
    }

    private void stripWithCorners(Level world, BlockPos startPos, BlockPos endPos, int startCV, int endCV, Direction relative, Direction frameFace, BlockState cornerState, boolean currPosX, boolean top) {
        if (this.currPos == null) {
            this.currPos = startPos;
        }
        if (this.canMineIfFrame(world.m_8055_(this.currPos), this.currPos)) {
            this.isTryingToMineFrame.setValue((Object)true);
            return;
        }
        this.isTryingToMineFrame.setValue((Object)false);
        if ((currPosX ? this.currPos.m_123341_() : this.currPos.m_123343_()) == startCV) {
            world.m_46597_(startPos, cornerState);
            this.repairedFrames.add(startPos);
            this.prevIsCorner = true;
        } else {
            if ((currPosX ? this.currPos.m_123341_() : this.currPos.m_123343_()) == endCV) {
                world.m_46597_(endPos, cornerState);
                this.repairedFrames.add(endPos);
                if (top) {
                    this.hasTopStrip = true;
                } else {
                    this.hasBottomStrip = true;
                }
                this.prevPos = new BlockPos(this.currPos.m_123341_(), this.currPos.m_123342_(), this.currPos.m_123343_());
                this.prevIsCorner = true;
                this.currPos = null;
                return;
            }
            world.m_46597_(this.currPos, (BlockState)((BlockState)((BlockFrame)((Object)ElectrodynamicsBlocks.BLOCK_FRAME.get())).m_49966_().m_61124_((Property)VoltaicBlockStates.FACING, (Comparable)frameFace)).m_61124_((Property)VoltaicBlockStates.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            this.repairedFrames.add(this.currPos);
            this.prevIsCorner = false;
        }
        world.m_5594_(null, this.currPos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.prevPos = new BlockPos(this.currPos.m_123341_(), this.currPos.m_123342_(), this.currPos.m_123343_());
        this.currPos = this.currPos.m_121945_((Boolean)this.cornerOnRight.getValue() != false ? relative.m_122424_() : relative);
    }

    private void strip(Level world, BlockPos startPos, int endCV, Direction relative, Direction frameFace, boolean currPosX, boolean left) {
        if (this.currPos == null) {
            this.currPos = startPos.m_121945_(relative);
        }
        if (this.canMineIfFrame(world.m_8055_(this.currPos), this.currPos)) {
            this.isTryingToMineFrame.setValue((Object)true);
            return;
        }
        this.isTryingToMineFrame.setValue((Object)false);
        world.m_46597_(this.currPos, (BlockState)((BlockState)((BlockFrame)((Object)ElectrodynamicsBlocks.BLOCK_FRAME.get())).m_49966_().m_61124_((Property)VoltaicBlockStates.FACING, (Comparable)((Boolean)this.cornerOnRight.getValue() != false ? frameFace.m_122424_() : frameFace))).m_61124_((Property)VoltaicBlockStates.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.repairedFrames.add(this.currPos);
        world.m_5594_(null, this.currPos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.prevPos = new BlockPos(this.currPos.m_123341_(), this.currPos.m_123342_(), this.currPos.m_123343_());
        this.prevIsCorner = false;
        this.currPos = this.currPos.m_121945_(relative);
        if ((currPosX ? this.currPos.m_123341_() : this.currPos.m_123343_()) == endCV) {
            this.currPos = null;
            if (left) {
                this.hasLeftStrip = true;
            } else {
                this.hasRightStrip = true;
            }
        }
    }

    private void checkComponents() {
        TileSeismicRelay relayin;
        TileSeismicRelay relayin2;
        TileMotorComplex complexin;
        TileMotorComplex complexin2;
        Direction facing = this.getFacing().m_122424_();
        Level world = this.m_58904_();
        BlockPos machinePos = this.m_58899_();
        Direction left = facing.m_122428_();
        Direction right = facing.m_122427_();
        BlockEntity leftEntity = world.m_7702_(machinePos.m_121945_(left));
        BlockEntity rightEntity = world.m_7702_(machinePos.m_121945_(right));
        BlockEntity aboveEntity = world.m_7702_(machinePos.m_7494_());
        if (leftEntity != null && leftEntity instanceof TileMotorComplex && (complexin2 = (TileMotorComplex)leftEntity).getFacing() == left) {
            this.complex = complexin2;
            this.hasMotorComplex.setValue((Object)true);
        } else if (rightEntity != null && rightEntity instanceof TileMotorComplex && (complexin = (TileMotorComplex)rightEntity).getFacing() == right) {
            this.complex = complexin;
            this.hasMotorComplex.setValue((Object)true);
        } else {
            this.complex = null;
            this.hasMotorComplex.setValue((Object)false);
        }
        if (leftEntity != null && leftEntity instanceof TileSeismicRelay && (relayin2 = (TileSeismicRelay)leftEntity).getFacing() == facing.m_122424_()) {
            this.corners.wipeList();
            this.corners.addValues((List)relayin2.markerLocs.getValue());
            this.cornerOnRight.setValue((Object)relayin2.cornerOnRight);
            this.relay = relayin2;
            this.hasSeismicRelay.setValue((Object)true);
        } else if (rightEntity != null && rightEntity instanceof TileSeismicRelay && (relayin = (TileSeismicRelay)rightEntity).getFacing() == facing.m_122424_()) {
            this.corners.wipeList();
            this.corners.addValues((List)relayin.markerLocs.getValue());
            this.cornerOnRight.setValue((Object)relayin.cornerOnRight);
            this.relay = relayin;
            this.hasSeismicRelay.setValue((Object)true);
        } else {
            this.relay = null;
            this.hasSeismicRelay.setValue((Object)false);
        }
        if (aboveEntity != null && aboveEntity instanceof TileCoolantResavoir) {
            TileCoolantResavoir resavoirin;
            this.resavoir = resavoirin = (TileCoolantResavoir)aboveEntity;
            this.hasCoolantResavoir.setValue((Object)true);
        } else {
            this.resavoir = null;
            this.hasCoolantResavoir.setValue((Object)false);
        }
    }

    private boolean areComponentsNull() {
        return this.complex == null || this.resavoir == null || this.relay == null;
    }

    private boolean hasAllStrips() {
        return this.hasBottomStrip && this.hasTopStrip && this.hasLeftStrip && this.hasRightStrip;
    }

    public boolean hasCorners() {
        return ((List)this.corners.getValue()).size() > 3;
    }

    private boolean skipBlock(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_50752_) || ((BlockPos)this.miningPos.getValue()).m_123342_() == this.f_58857_.m_141937_() || state.m_60734_() instanceof LiquidBlock;
    }

    private void tickClient(ComponentTickable tick) {
        if (this.renderHandler == null) {
            this.renderHandler = new QuarryRenderManger();
        }
        this.renderHandler.render(this);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        CompoundTag data = new CompoundTag();
        data.m_128379_("bottomStrip", this.hasBottomStrip);
        data.m_128379_("topStrip", this.hasTopStrip);
        data.m_128379_("leftStrip", this.hasLeftStrip);
        data.m_128379_("rightStrip", this.hasRightStrip);
        if (this.currPos != null) {
            data.m_128405_("currX", this.currPos.m_123341_());
            data.m_128405_("currY", this.currPos.m_123342_());
            data.m_128405_("currZ", this.currPos.m_123343_());
        }
        if (this.prevPos != null) {
            data.m_128405_("prevX", this.prevPos.m_123341_());
            data.m_128405_("prevY", this.prevPos.m_123342_());
            data.m_128405_("prevZ", this.prevPos.m_123343_());
        }
        data.m_128379_("prevIsCorner", this.prevIsCorner);
        data.m_128379_("lastIsCorner", this.lastIsCorner);
        data.m_128379_("hasDecayed", this.hasHandledDecay);
        data.m_128405_("heightShiftCA", this.heightShiftCA);
        data.m_128405_("widthShiftCA", this.widthShiftCA);
        data.m_128405_("tickDelayCA", this.tickDelayCA);
        data.m_128405_("lengthShiftMiner", this.lengthShiftMiner);
        data.m_128405_("heightShiftMiner", this.heightShiftMiner);
        data.m_128405_("widthShiftMiner", this.widthShiftMiner);
        data.m_128405_("tickDelayMiner", this.tickDelayMiner);
        data.m_128379_("lengthReverse", this.lengthReverse);
        data.m_128379_("widthReverse", this.widthReverse);
        data.m_128405_("widthShiftCR", this.widthShiftCR);
        data.m_128405_("widthShiftMaintainMining", this.widthShiftMaintainMining);
        if (this.placedBy != null) {
            data.m_128362_("placedBy", this.placedBy);
        }
        data.m_128379_("continue", this.cont);
        int i = 0;
        for (Map.Entry<BlockPos, BlockState> entry : this.brokenFrames.entrySet()) {
            data.m_128365_("brokenframe" + i, (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
            BlockFrame.writeToNbt(data, "brokenstate" + i, entry.getValue());
            ++i;
        }
        data.m_128405_("brokenframecount", i);
        i = 0;
        for (BlockPos pos : this.repairedFrames) {
            data.m_128365_("repairedframe" + i, (Tag)NbtUtils.m_129224_((BlockPos)pos));
            ++i;
        }
        data.m_128405_("repairedframecount", i);
        compound.m_128365_("quarrydata", (Tag)data);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag data = compound.m_128469_("quarrydata");
        this.hasBottomStrip = data.m_128471_("bottomStrip");
        this.hasTopStrip = data.m_128471_("topStrip");
        this.hasLeftStrip = data.m_128471_("leftStrip");
        this.hasRightStrip = data.m_128471_("rightStrip");
        this.currPos = data.m_128441_("currX") ? new BlockPos(data.m_128451_("currX"), data.m_128451_("currY"), data.m_128451_("currZ")) : null;
        this.prevPos = data.m_128441_("prevY") ? new BlockPos(data.m_128451_("prevX"), data.m_128451_("prevY"), data.m_128451_("prevZ")) : null;
        this.prevIsCorner = data.m_128471_("prevIsCorner");
        this.lastIsCorner = data.m_128471_("lastIsCorner");
        this.hasHandledDecay = data.m_128471_("hasDecayed");
        this.heightShiftCA = data.m_128451_("heightShiftCA");
        this.widthShiftCA = data.m_128451_("widthShiftCA");
        this.tickDelayCA = data.m_128451_("tickDelayCA");
        this.lengthShiftMiner = data.m_128451_("lengthShiftMiner");
        this.heightShiftMiner = data.m_128451_("heightShiftMiner");
        this.widthShiftMiner = data.m_128451_("widthShiftMiner");
        this.tickDelayMiner = data.m_128451_("tickDelayMiner");
        this.lengthReverse = data.m_128471_("lengthReverse");
        this.widthReverse = data.m_128471_("widthReverse");
        this.widthShiftCR = data.m_128451_("widthShiftCR");
        this.widthShiftMaintainMining = data.m_128451_("widthShiftMaintainMining");
        if (data.m_128441_("placedBy")) {
            this.placedBy = data.m_128342_("placedBy");
        }
        this.cont = data.m_128471_("continue");
        int brokenSize = data.m_128451_("brokenframecount");
        for (int i = 0; i < brokenSize; ++i) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("brokenframe" + i));
            BlockState state = BlockFrame.readFromNbt(data.m_128469_("brokenstate" + i));
            this.brokenFrames.put(pos, state);
        }
        int repairSize = data.m_128451_("repairedframecount");
        for (int i = 0; i < repairSize; ++i) {
            this.repairedFrames.add(NbtUtils.m_129239_((CompoundTag)data.m_128469_("repairedframe" + i)));
        }
        compound.m_128473_("quarrydata");
    }

    public void m_7651_() {
        if (this.m_58904_().f_46443_) {
            HandlerQuarryArm.removeRenderData(this.m_58899_());
        }
        super.m_7651_();
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.handleFramesDecayNoVarUpdate();
    }

    public void handleFramesDecay() {
        this.miningPos.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        this.prevMiningPos.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        this.hasHandledDecay = true;
        this.isAreaCleared.setValue((Object)false);
        this.hasRing.setValue((Object)false);
        this.hasBottomStrip = false;
        this.hasTopStrip = false;
        this.hasLeftStrip = false;
        this.hasRightStrip = false;
        this.lengthReverse = false;
        this.widthReverse = false;
        this.isFinished.setValue((Object)true);
        this.isChanged = true;
        this.progressCounter.setValue((Object)0);
        this.running.setValue((Object)false);
        this.brokenFrames.clear();
        this.repairedFrames.clear();
        this.corners.wipeList();
        this.handleFramesDecayNoVarUpdate();
    }

    public void handleFramesDecayNoVarUpdate() {
        if (!this.hasCorners()) {
            return;
        }
        Level world = this.m_58904_();
        BlockPos frontOfQuarry = (BlockPos)((List)this.corners.getValue()).get(0);
        BlockPos foqFar = (BlockPos)((List)this.corners.getValue()).get(1);
        BlockPos foqCorner = (BlockPos)((List)this.corners.getValue()).get(2);
        BlockPos farCorner = (BlockPos)((List)this.corners.getValue()).get(3);
        for (BlockPos pos2 : (List)this.corners.getValue()) {
            world.m_46597_(pos2, Blocks.f_50016_.m_49966_());
        }
        BlockPos.m_121990_((BlockPos)foqCorner, (BlockPos)frontOfQuarry).forEach(pos -> TileQuarry.updateState(world, pos));
        BlockPos.m_121990_((BlockPos)farCorner, (BlockPos)foqFar).forEach(pos -> TileQuarry.updateState(world, pos));
        BlockPos.m_121990_((BlockPos)foqCorner, (BlockPos)farCorner).forEach(pos -> TileQuarry.updateState(world, pos));
        BlockPos.m_121990_((BlockPos)frontOfQuarry, (BlockPos)foqFar).forEach(pos -> TileQuarry.updateState(world, pos));
    }

    private static void updateState(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_FRAME.get()) || state.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_FRAME_CORNER.get())) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY, (Comparable)Boolean.TRUE));
        }
    }

    public void setPlayer(LivingEntity player) {
        this.placedBy = player == null ? null : player.m_20148_();
    }

    public UUID getPlayerID() {
        return this.placedBy;
    }

    @Nullable
    private FakePlayer getPlayer(ServerLevel world) {
        if (this.placedBy == null) {
            return null;
        }
        Player player = world.m_46003_(this.placedBy);
        if (player != null) {
            return FakePlayerFactory.get((ServerLevel)world, (GameProfile)player.m_36316_());
        }
        return null;
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (!(inv.getUpgradeContents().isEmpty() || slot < inv.getUpgradeSlotStartIndex() && slot != -1)) {
            double quarryPowerMultiplier = 0.0;
            int silkTouchLevel = 0;
            int fortuneLevel = 0;
            int unbreakingLevel = 0;
            boolean hasItemVoid = false;
            for (ItemStack stack : inv.getUpgradeContents()) {
                if (stack.m_41619_()) continue;
                ItemUpgrade upgrade = (ItemUpgrade)stack.m_41720_();
                block7: for (int i = 0; i < stack.m_41613_(); ++i) {
                    switch (upgrade.subtype) {
                        case itemvoid: {
                            hasItemVoid = true;
                            if (!(quarryPowerMultiplier < 1.0)) continue block7;
                            quarryPowerMultiplier = 1.0;
                            continue block7;
                        }
                        case silktouch: {
                            if (fortuneLevel == 0 && silkTouchLevel < 1) {
                                ++silkTouchLevel;
                            }
                            if (quarryPowerMultiplier < 1.0) {
                                quarryPowerMultiplier = 1.0;
                            }
                            quarryPowerMultiplier *= 4.0;
                            quarryPowerMultiplier = Math.min(quarryPowerMultiplier, 1000.0);
                            continue block7;
                        }
                        case fortune: {
                            if (silkTouchLevel == 0 && fortuneLevel < 3) {
                                ++fortuneLevel;
                            }
                            if (quarryPowerMultiplier < 1.0) {
                                quarryPowerMultiplier = 1.0;
                            }
                            quarryPowerMultiplier *= 2.0;
                            quarryPowerMultiplier = Math.min(quarryPowerMultiplier, 1000.0);
                            continue block7;
                        }
                        case unbreaking: {
                            if (quarryPowerMultiplier < 1.0) {
                                quarryPowerMultiplier = 1.0;
                            }
                            if (unbreakingLevel < 3) {
                                ++unbreakingLevel;
                            }
                            quarryPowerMultiplier *= 1.5;
                            quarryPowerMultiplier = Math.min(quarryPowerMultiplier, 1000.0);
                            continue block7;
                        }
                    }
                }
            }
            this.hasItemVoid.setValue((Object)hasItemVoid);
            this.fortuneLevel.setValue((Object)fortuneLevel);
            this.silkTouchLevel.setValue((Object)silkTouchLevel);
            this.unbreakingLevel.setValue((Object)unbreakingLevel);
            this.quarryPowerUsage.setValue((Object)(ElectroConstants.QUARRY_USAGE_PER_TICK * quarryPowerMultiplier));
        }
    }

    private void writeHeadType(SubtypeDrillHead head) {
        if (head == null) {
            this.currHead.setValue((Object)-1);
        } else {
            this.currHead.setValue((Object)head.ordinal());
        }
    }

    @Nullable
    public SubtypeDrillHead readHeadType() {
        return (Integer)this.currHead.getValue() == -1 ? null : SubtypeDrillHead.values()[(Integer)this.currHead.getValue()];
    }

    @Nullable
    public TileMotorComplex getMotorComplex() {
        Direction facing = this.getFacing().m_122424_();
        BlockEntity entity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing.m_122427_()));
        if (entity != null && entity instanceof TileMotorComplex) {
            TileMotorComplex complex = (TileMotorComplex)entity;
            return complex;
        }
        entity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing.m_122428_()));
        if (entity != null && entity instanceof TileMotorComplex) {
            TileMotorComplex complex = (TileMotorComplex)entity;
            return complex;
        }
        return null;
    }

    @Nullable
    public TileCoolantResavoir getFluidResavoir() {
        BlockEntity entity = this.f_58857_.m_7702_(this.m_58899_().m_7918_(0, 1, 0));
        if (entity != null && entity instanceof TileCoolantResavoir) {
            TileCoolantResavoir resavoir = (TileCoolantResavoir)entity;
            return resavoir;
        }
        return null;
    }

    @Nullable
    public TileSeismicRelay getSeismicRelay() {
        Direction facing = this.getFacing().m_122424_();
        BlockEntity entity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing.m_122427_()));
        if (entity != null && entity instanceof TileSeismicRelay) {
            TileSeismicRelay relay = (TileSeismicRelay)entity;
            return relay;
        }
        entity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing.m_122428_()));
        if (entity != null && entity instanceof TileSeismicRelay) {
            TileSeismicRelay relay = (TileSeismicRelay)entity;
            return relay;
        }
        return null;
    }

    public boolean isMotorComplexPowered() {
        if (!this.f_58857_.f_46443_) {
            return this.complex != null && (Boolean)this.complex.isPowered.getValue() != false;
        }
        TileMotorComplex complex = this.getMotorComplex();
        if (complex == null) {
            return false;
        }
        return (Boolean)complex.isPowered.getValue();
    }

    public boolean canMineIfFrame(BlockState state, BlockPos pos) {
        BlockEntity entity;
        if ((state.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_FRAME.get()) || state.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_FRAME_CORNER.get())) && (entity = this.f_58857_.m_7702_(pos)) != null && entity instanceof TileFrame) {
            TileFrame frame = (TileFrame)entity;
            return frame.ownerQuarryPos != null;
        }
        return false;
    }

    public int getComparatorSignal() {
        return (Boolean)this.isFinished.getValue() != false ? 15 : 0;
    }
}

