/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas;

import electrodynamics.common.tile.pipelines.GenericTileValve;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class TileGasValve
extends GenericTileValve {
    private boolean isLocked = false;

    public TileGasValve(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_GASVALVE.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap != VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK || side == null || this.isLocked) {
            return LazyOptional.empty();
        }
        Direction facing = this.getFacing();
        if (BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileGasValve.INPUT_DIR.mappedDir) == side || BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileGasValve.OUTPUT_DIR.mappedDir) == side) {
            BlockEntity relative = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side.m_122424_()));
            if (relative == null) {
                return LazyOptional.of(() -> CapabilityUtils.EMPTY_GAS).cast();
            }
            this.isLocked = true;
            IGasHandler gas = (IGasHandler)relative.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, side).orElse((Object)CapabilityUtils.EMPTY_GAS);
            this.isLocked = false;
            return gas == CapabilityUtils.EMPTY_GAS ? LazyOptional.of(() -> CapabilityUtils.EMPTY_GAS).cast() : LazyOptional.of(() -> new CapDispatcher(gas)).cast();
        }
        return super.getCapability(cap, side);
    }

    private class CapDispatcher
    implements IGasHandler {
        private final IGasHandler parent;

        private CapDispatcher(IGasHandler parent) {
            this.parent = parent;
        }

        public int getTanks() {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return 0;
            }
            TileGasValve.this.isLocked = true;
            int tanks = this.parent.getTanks();
            TileGasValve.this.isLocked = false;
            return tanks;
        }

        public GasStack getGasInTank(int tank) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return GasStack.EMPTY;
            }
            TileGasValve.this.isLocked = true;
            GasStack stack = this.parent.getGasInTank(tank);
            TileGasValve.this.isLocked = false;
            return stack;
        }

        public int getTankCapacity(int tank) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return 0;
            }
            TileGasValve.this.isLocked = true;
            int cap = this.parent.getTankCapacity(tank);
            TileGasValve.this.isLocked = false;
            return cap;
        }

        public int getTankMaxTemperature(int tank) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return 0;
            }
            TileGasValve.this.isLocked = true;
            int temp = this.parent.getTankMaxTemperature(tank);
            TileGasValve.this.isLocked = false;
            return temp;
        }

        public int getTankMaxPressure(int tank) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return 0;
            }
            TileGasValve.this.isLocked = true;
            int pres = this.parent.getTankMaxPressure(tank);
            TileGasValve.this.isLocked = false;
            return pres;
        }

        public boolean isGasValid(int tank, GasStack gas) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return false;
            }
            TileGasValve.this.isLocked = true;
            boolean valid = this.parent.isGasValid(tank, gas);
            TileGasValve.this.isLocked = false;
            return valid;
        }

        public int fill(GasStack gas, GasAction action) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return 0;
            }
            TileGasValve.this.isLocked = true;
            int fill = this.parent.fill(gas, action);
            TileGasValve.this.isLocked = false;
            return fill;
        }

        public GasStack drain(GasStack gas, GasAction action) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return GasStack.EMPTY;
            }
            TileGasValve.this.isLocked = true;
            GasStack drain = this.parent.drain(gas, action);
            TileGasValve.this.isLocked = false;
            return drain;
        }

        public GasStack drain(int maxFill, GasAction action) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return GasStack.EMPTY;
            }
            TileGasValve.this.isLocked = true;
            GasStack drain = this.parent.drain(maxFill, action);
            TileGasValve.this.isLocked = false;
            return drain;
        }

        public int heat(int tank, int deltaTemperature, GasAction action) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return -1;
            }
            TileGasValve.this.isLocked = true;
            int heat = this.parent.heat(tank, deltaTemperature, action);
            TileGasValve.this.isLocked = false;
            return heat;
        }

        public int bringPressureTo(int tank, int atm, GasAction action) {
            if (TileGasValve.this.isClosed || TileGasValve.this.isLocked) {
                return -1;
            }
            TileGasValve.this.isLocked = true;
            int pres = this.parent.bringPressureTo(tank, atm, action);
            TileGasValve.this.isLocked = false;
            return pres;
        }
    }
}

