/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IAddonTankManager;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileGasTransformerAddonTank
extends GenericTile {
    private BlockPos ownerPos = BlockEntityUtils.OUT_OF_REACH;

    public TileGasTransformerAddonTank(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_COMPRESSOR_ADDONTANK.get(), worldPos, blockState);
    }

    public void setOwnerPos(BlockPos ownerPos) {
        this.ownerPos = ownerPos;
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos above = this.m_58899_().m_7494_();
        BlockEntity aboveTile = this.m_58904_().m_7702_(above);
        for (int i = 0; i < ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_LIMIT; ++i) {
            if (aboveTile instanceof TileGasTransformerAddonTank) {
                TileGasTransformerAddonTank tank = (TileGasTransformerAddonTank)aboveTile;
                tank.setOwnerPos(BlockEntityUtils.OUT_OF_REACH);
            }
            above = above.m_7494_();
            aboveTile = this.m_58904_().m_7702_(above);
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.ownerPos);
        if (blockEntity instanceof IAddonTankManager) {
            IAddonTankManager manager = (IAddonTankManager)blockEntity;
            manager.updateTankCount();
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos belowPos = this.m_58899_().m_7495_();
        BlockState below = this.m_58904_().m_8055_(belowPos);
        for (int i = 0; i < ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_LIMIT; ++i) {
            BlockEntity blockEntity = this.m_58904_().m_7702_(belowPos);
            if (blockEntity instanceof IAddonTankManager) {
                IAddonTankManager manager = (IAddonTankManager)blockEntity;
                manager.updateTankCount();
                break;
            }
            if (!below.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK.get())) break;
            belowPos = belowPos.m_7495_();
            below = this.m_58904_().m_8055_(belowPos);
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.ownerPos);
        if (blockEntity instanceof GenericTile) {
            GenericTile compressor = (GenericTile)blockEntity;
            return compressor.use(player, hand, hit);
        }
        return super.use(player, hand, hit);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("owner", (Tag)NbtUtils.m_129224_((BlockPos)this.ownerPos));
    }

    public void m_142466_(CompoundTag compound) {
        BlockPos optional;
        super.m_142466_(compound);
        this.ownerPos = optional = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("owner"));
    }
}

