/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer.compressor;

import electrodynamics.common.inventory.container.tile.ContainerAdvancedCompressor;
import electrodynamics.common.inventory.container.tile.ContainerAdvancedDecompressor;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IMultiblockGasTransformer;
import electrodynamics.common.tile.pipelines.gas.gastransformer.TileGasTransformerSideBlock;
import electrodynamics.common.tile.pipelines.gas.gastransformer.compressor.GenericTileCompressor;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public abstract class GenericTileAdvancedCompressor
extends GenericTileCompressor
implements IMultiblockGasTransformer {
    public boolean hasBeenDestroyed = false;
    public final SingleProperty<Double> pressureMultiplier;

    public GenericTileAdvancedCompressor(BlockEntityType<?> type, BlockPos worldPos, BlockState blockState, double defaultMultiplier) {
        super(type, worldPos, blockState);
        this.pressureMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "pressuremultiplier", (Object)defaultMultiplier));
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        super.tickClient(tickable);
        if (this.f_58857_.m_213780_().m_188500_() < 0.15) {
            // empty if block
        }
    }

    @Override
    public void updateAddonTanks(int count, boolean isLeft) {
        ComponentGasHandlerMulti handler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        if (isLeft) {
            handler.getInputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * count);
        } else {
            handler.getOutputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * count);
        }
    }

    @Override
    public boolean hasBeenDestroyed() {
        return this.hasBeenDestroyed;
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        Direction facing = this.getFacing();
        BlockEntity left = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.EAST)));
        BlockEntity right = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.WEST)));
        if (left != null && right != null && left instanceof TileGasTransformerSideBlock) {
            TileGasTransformerSideBlock leftTile = (TileGasTransformerSideBlock)left;
            if (right instanceof TileGasTransformerSideBlock) {
                TileGasTransformerSideBlock rightTile = (TileGasTransformerSideBlock)right;
                leftTile.setOwnerPos(this.m_58899_());
                leftTile.setIsLeft();
                leftTile.m_6596_();
                rightTile.setOwnerPos(this.m_58899_());
                rightTile.m_6596_();
            }
        }
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_ || this.hasBeenDestroyed) {
            return;
        }
        this.hasBeenDestroyed = true;
        Direction facing = this.getFacing();
        this.m_58904_().m_46961_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.WEST)), false);
        this.m_58904_().m_46961_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.EAST)), false);
    }

    @Override
    public void outputToPipe(ComponentProcessor processor, ComponentGasHandlerMulti gasHandler, Direction facing) {
        IGasHandler handler;
        Direction direction = BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)BlockEntityUtils.MachineDirection.LEFT.mappedDir);
        BlockPos face = this.m_58899_().m_5484_(direction, 2);
        BlockEntity faceTile = this.m_58904_().m_7702_(face);
        if (faceTile != null && (handler = (IGasHandler)faceTile.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, direction.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_GAS)) != CapabilityUtils.EMPTY_GAS) {
            PropertyGasTank gasTank = gasHandler.getOutputTanks()[0];
            for (int i = 0; i < handler.getTanks(); ++i) {
                GasStack tankGas = gasTank.getGas();
                int amtAccepted = handler.fill(tankGas, GasAction.EXECUTE);
                GasStack taken = new GasStack(tankGas.getGas(), amtAccepted, tankGas.getTemperature(), tankGas.getPressure());
                gasTank.drain(taken, GasAction.EXECUTE);
            }
        }
    }

    @Override
    public void updateLit(boolean canProcess, Direction facing) {
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canProcess) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canProcess);
            BlockEntity left = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.EAST)));
            BlockEntity right = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.WEST)));
            if (left != null && left instanceof TileGasTransformerSideBlock) {
                TileGasTransformerSideBlock leftTile = (TileGasTransformerSideBlock)left;
                if (right != null && right instanceof TileGasTransformerSideBlock) {
                    TileGasTransformerSideBlock rightTile = (TileGasTransformerSideBlock)right;
                    BlockEntityUtils.updateLit((GenericTile)leftTile, (Boolean)canProcess);
                    BlockEntityUtils.updateLit((GenericTile)rightTile, (Boolean)canProcess);
                }
            }
        }
    }

    @Override
    public double getPressureMultiplier() {
        return (Double)this.pressureMultiplier.getValue();
    }

    public static class TileAdvancedDecompressor
    extends GenericTileAdvancedCompressor {
        public TileAdvancedDecompressor(BlockPos worldPos, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_ADVANCEDDECOMPRESSOR.get(), worldPos, blockState, 0.5);
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)ElectrodynamicsSounds.SOUND_DECOMPRESSORRUNNING.get();
        }

        @Override
        public ComponentContainerProvider getContainerProvider() {
            return new ComponentContainerProvider("advanceddecompressor", (GenericTile)this).createMenu((id, inv) -> new ContainerAdvancedDecompressor((int)id, (Inventory)inv, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
        }

        @Override
        public double getUsagePerTick() {
            return ElectroConstants.ADVANCED_DECOMPRESSOR_USAGE_PER_TICK;
        }

        @Override
        public int getConversionRate() {
            return ElectroConstants.ADVANCED_DECOMPRESSOR_CONVERSION_RATE;
        }
    }

    public static class TileAdvancedCompressor
    extends GenericTileAdvancedCompressor {
        public TileAdvancedCompressor(BlockPos worldPos, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_ADVANCEDCOMPRESSOR.get(), worldPos, blockState, 2.0);
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)ElectrodynamicsSounds.SOUND_COMPRESSORRUNNING.get();
        }

        @Override
        public ComponentContainerProvider getContainerProvider() {
            return new ComponentContainerProvider("advancedcompressor", (GenericTile)this).createMenu((id, inv) -> new ContainerAdvancedCompressor((int)id, (Inventory)inv, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
        }

        @Override
        public double getUsagePerTick() {
            return ElectroConstants.ADVACNED_COMPRESSOR_USAGE_PER_TICK;
        }

        @Override
        public int getConversionRate() {
            return ElectroConstants.ADVACNED_COMPRESSOR_CONVERSION_RATE;
        }
    }
}

