/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.prefab.utilities;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class ElectroTextUtils {
    public static final String GUI_BASE = "gui";
    public static final String TOOLTIP_BASE = "tooltip";
    public static final String JEI_BASE = "jei";
    public static final String GUIDEBOOK_BASE = "guidebook";
    public static final String MESSAGE_BASE = "chat";
    public static final String JEI_INFO_ITEM = "info.item";
    public static final String JEI_INFO_FLUID = "info.fluid";
    public static final String BLOCK_BASE = "block";
    public static final String GAS_BASE = "gas";
    public static final String ADVANCEMENT_BASE = "advancement";
    public static final String DIMENSION = "dimension";
    public static final String CREATIVE_TAB = "creativetab";

    public static MutableComponent tooltip(String key, Object ... additional) {
        return ElectroTextUtils.translated(TOOLTIP_BASE, key, additional);
    }

    public static MutableComponent guidebook(String key, Object ... additional) {
        return ElectroTextUtils.translated(GUIDEBOOK_BASE, key, additional);
    }

    public static MutableComponent gui(String key, Object ... additional) {
        return ElectroTextUtils.translated(GUI_BASE, key, additional);
    }

    public static MutableComponent chatMessage(String key, Object ... additional) {
        return ElectroTextUtils.translated(MESSAGE_BASE, key, additional);
    }

    public static MutableComponent jeiTranslated(String key, Object ... additional) {
        return Component.m_237110_((String)("jei." + key), (Object[])additional);
    }

    public static MutableComponent jeiItemTranslated(String key, Object ... additional) {
        return ElectroTextUtils.jeiTranslated("info.item." + key, additional);
    }

    public static MutableComponent jeiFluidTranslated(String key, Object ... additional) {
        return ElectroTextUtils.jeiTranslated("info.fluid." + key, additional);
    }

    public static MutableComponent block(String key, Object ... additional) {
        return ElectroTextUtils.translated(BLOCK_BASE, key, additional);
    }

    public static MutableComponent gas(String key, Object ... additional) {
        return ElectroTextUtils.translated(GAS_BASE, key, additional);
    }

    public static MutableComponent advancement(String key, Object ... additional) {
        return ElectroTextUtils.translated(ADVANCEMENT_BASE, key, additional);
    }

    public static MutableComponent dimension(String key, Object ... additional) {
        return ElectroTextUtils.translated(DIMENSION, key, additional);
    }

    public static MutableComponent dimension(ResourceKey<Level> level, Object ... additional) {
        return ElectroTextUtils.dimension(level.m_135782_().m_135815_(), additional);
    }

    public static MutableComponent creativeTab(String key, Object ... additional) {
        return ElectroTextUtils.translated(CREATIVE_TAB, key, additional);
    }

    public static MutableComponent translated(String base, String key, Object ... additional) {
        return Component.m_237110_((String)(base + ".electrodynamics." + key), (Object[])additional);
    }

    public static boolean guiExists(String key) {
        return ElectroTextUtils.translationExists(GUI_BASE, key);
    }

    public static boolean tooltipExists(String key) {
        return ElectroTextUtils.translationExists(TOOLTIP_BASE, key);
    }

    public static boolean dimensionExistst(String key) {
        return ElectroTextUtils.translationExists(DIMENSION, key);
    }

    public static boolean dimensionExists(ResourceKey<Level> level) {
        return ElectroTextUtils.dimensionExistst(level.m_135782_().m_135815_());
    }

    public static boolean translationExists(String base, String key) {
        return I18n.m_118936_((String)(base + ".electrodynamics." + key));
    }
}

