/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.util.Platform;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemMEPackingTape
extends Item {
    private static final ObjectSet<ResourceLocation> WHITE_LIST = new ObjectOpenHashSet();

    public ItemMEPackingTape() {
        super(new Item.Properties().m_41503_(64));
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity tile = world.m_7702_(pos);
        Player player = context.m_43723_();
        if (tile != null && player != null) {
            CompoundTag tag = new CompoundTag();
            if (tile instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)tile;
                Vec3 hitVec = context.m_43720_();
                Vec3 hitInBlock = new Vec3(hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82480_ - (double)pos.m_123342_(), hitVec.f_82481_ - (double)pos.m_123343_());
                IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
                if (part != null) {
                    tag.m_128379_("part", true);
                    Item partItem = part.getPartItem().m_5456_();
                    ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)partItem);
                    if (!WHITE_LIST.contains((Object)id)) {
                        return InteractionResult.PASS;
                    }
                    assert (id != null);
                    tag.m_128359_("id", id.toString());
                    CompoundTag ctxTag = new CompoundTag();
                    part.writeToNBT(ctxTag);
                    tag.m_128365_("ctx", (Tag)ctxTag);
                    cable.removePart(part);
                }
            } else {
                tag.m_128379_("part", false);
                BlockState state = tile.m_58900_();
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                if (!WHITE_LIST.contains((Object)blockId)) {
                    return InteractionResult.PASS;
                }
                ResourceLocation id = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.m_58903_());
                assert (id != null);
                assert (blockId != null);
                tag.m_128359_("id", id.toString());
                tag.m_128359_("block_id", blockId.toString());
                tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
                CompoundTag ctxTag = tile.serializeNBT();
                tag.m_128365_("ctx", (Tag)ctxTag);
                world.m_46747_(pos);
                world.m_7471_(pos, false);
            }
            if (!tag.m_128456_()) {
                ItemStack pack = new ItemStack((ItemLike)EPPItemAndBlock.PACKAGE);
                pack.m_41751_(tag);
                Platform.spawnDrops((Level)world, (BlockPos)pos, Collections.singletonList(pack));
                context.m_43722_().m_41622_(1, (LivingEntity)player, e -> e.m_21190_(context.m_43724_()));
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public static void registerPackableDevice(ResourceLocation id) {
        WHITE_LIST.add((Object)id);
    }
}

