/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.common.capability.FluxPlayer;
import sonar.fluxnetworks.common.capability.FluxPlayerProvider;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.util.FluxCommands;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;

@Mod.EventBusSubscriber(modid="fluxnetworks")
public class EventHandler {
    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        FluxNetworkData.release();
    }

    @SubscribeEvent
    public static void onServerTick(@Nonnull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FluxNetworkData.getAllNetworks().forEach(FluxNetwork::onEndServerTick);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        BlockState base;
        BlockPos pos;
        if (!FluxConfig.enableFluxRecipe || event.getLevel().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockState crusher = level.m_8055_(pos = event.getPos());
        if (crusher.m_60734_() == Blocks.f_50080_ && ((base = level.m_8055_(pos.m_6625_(2))).m_60734_() == Blocks.f_50752_ || base.m_60734_() == RegistryBlocks.FLUX_BLOCK.get())) {
            ItemEntity entity2;
            List entities = level.m_45976_(ItemEntity.class, new AABB(pos.m_7495_()));
            if (entities.isEmpty()) {
                return;
            }
            int itemCount = 0;
            for (ItemEntity entity2 : entities) {
                if (!entity2.m_32055_().m_150930_(Items.f_42451_)) continue;
                entity2.m_146870_();
                if ((itemCount += entity2.m_32055_().m_41613_()) < 512) continue;
                break;
            }
            if (itemCount == 0) {
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get(), itemCount);
            level.m_7471_(pos, false);
            entity2 = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, stack);
            entity2.m_32061_();
            entity2.m_20334_(0.0, 0.2, 0.0);
            level.m_7967_((Entity)entity2);
            if (level.m_213780_().m_188500_() > Math.pow(0.9, itemCount >> 3)) {
                level.m_7731_(pos.m_7495_(), Blocks.f_50652_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_11892_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.m_7731_(pos.m_7495_(), crusher, 3);
                level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            int particleCount = Mth.m_14045_((int)(itemCount >> 2), (int)4, (int)64);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, particleCount, 0.0, 0.0, 0.0, 0.0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        Channel.get().sendToPlayer(Messages.updateNetwork(FluxNetworkData.getAllNetworks(), (byte)21), event.getEntity());
        Messages.syncCapability(event.getEntity());
    }

    @SubscribeEvent
    public static void onAttachCapability(@Nonnull AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayer) {
            FluxPlayerProvider provider = new FluxPlayerProvider();
            event.addCapability(FluxPlayerProvider.CAP_KEY, (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(@Nonnull PlayerEvent.Clone event) {
        FluxPlayer nFluxPlayer;
        event.getOriginal().reviveCaps();
        FluxPlayer oFluxPlayer = FluxUtils.get((ICapabilityProvider)event.getOriginal(), FluxPlayer.FLUX_PLAYER);
        if (oFluxPlayer != null && (nFluxPlayer = FluxUtils.get((ICapabilityProvider)event.getEntity(), FluxPlayer.FLUX_PLAYER)) != null) {
            nFluxPlayer.set(oFluxPlayer);
        }
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onRegisterCommands(@Nonnull RegisterCommandsEvent event) {
        FluxCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

