/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.BlockSnapshot;

public interface IPole
extends IWaterLoggable {
    public static boolean isEmptyPlace(LevelReader level, BlockPos pos) {
        return !level.m_151570_(pos) && level.m_46805_(pos) && (GameWorld.isAirBlock(level, pos) || GameWorld.isWaterBlock(level, pos));
    }

    public static boolean replaceWith(BlockState state, ServerLevel level, BlockPos pos) {
        BlockState oldState = level.m_8055_(pos);
        BlockState newState = IWaterLoggable.getStateForPlacementAt((LevelReader)level, pos, state);
        return newState == oldState || level.m_46597_(pos, newState);
    }

    public boolean isApex(BlockState var1);

    public boolean isPole(BlockState var1);

    default public boolean isApex(LevelReader level, BlockPos pos) {
        return level.m_46805_(pos) && this.isApex(level.m_8055_(pos));
    }

    default public boolean isPole(LevelReader level, BlockPos pos) {
        return level.m_46805_(pos) && this.isPole(level.m_8055_(pos));
    }

    default public boolean canBuildUp(Level level, BlockPos startPos) {
        BlockPos top = this.getTop((LevelReader)level, startPos).m_7494_();
        if (this.isApex((LevelReader)level, top)) {
            top = top.m_7494_();
        }
        return IPole.isEmptyPlace((LevelReader)level, top);
    }

    default public boolean canStayAt(LevelReader level, BlockPos pos) {
        BlockPos down = pos.m_7495_();
        if (this.isPole(level, down) || Block.m_49863_((LevelReader)level, (BlockPos)down, (Direction)Direction.UP)) {
            return true;
        }
        BlockPos up = pos.m_7494_();
        return this.isPole(level, up) || Block.m_49863_((LevelReader)level, (BlockPos)up, (Direction)Direction.DOWN);
    }

    default public BlockPos getTop(LevelReader level, BlockPos startPos) {
        return GameWorld.Positions.getLastInLine(level, startPos, this::isPole, Direction.UP);
    }

    default public BlockPos getBottom(LevelReader level, BlockPos startPos) {
        return GameWorld.Positions.getLastInLine(level, startPos, this::isPole, Direction.DOWN);
    }

    default public int buildUp(ServerLevel level, BlockPos from, BlockState poleToAdd, int quantity) {
        int i;
        if (!this.isPole((LevelReader)level, from)) {
            return 0;
        }
        BlockPos top = this.getTop((LevelReader)level, from);
        Optional<Apex> apex = this.isApex((LevelReader)level, top.m_7494_()) ? Optional.of(new Apex((Level)level, top.m_7494_())) : Optional.empty();
        int empty = 0;
        int n = i = apex.isPresent() ? 2 : 1;
        while (empty < quantity && IPole.isEmptyPlace((LevelReader)level, top.m_6630_(i))) {
            ++empty;
            ++i;
        }
        if ((quantity = Math.min(quantity, empty)) < 1) {
            return 0;
        }
        apex.ifPresent(Apex::removeBlock);
        for (int y = top.m_123342_(); y >= from.m_123342_(); --y) {
            BlockPos source = GameWorld.Positions.withY(from, y);
            BlockPos dest = source.m_6630_(quantity);
            BlockState poleToMove = level.m_8055_(source);
            if (IWaterLoggable.isWaterlogged(poleToMove)) {
                poleToMove = (BlockState)poleToMove.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            IPole.replaceWith(poleToMove, level, dest);
        }
        int added = 0;
        for (int i2 = 0; i2 < quantity; ++i2) {
            if (!IPole.replaceWith(poleToAdd, level, from.m_6630_(i2))) continue;
            ++added;
        }
        if (apex.isPresent()) {
            ((Apex)apex.get()).restoreAt((Level)level, ((Apex)apex.get()).getPos().m_6630_(quantity));
        }
        return added;
    }

    default public int breakDown(ServerLevel level, BlockPos from, int quantity, boolean dropItems) {
        int i;
        if (!this.isPole((LevelReader)level, from)) {
            return 0;
        }
        BlockPos top = this.getTop((LevelReader)level, from);
        int poleLength = top.m_123342_() - from.m_123342_() + 1;
        quantity = Math.min(quantity, poleLength);
        Optional<Apex> apex = this.isApex((LevelReader)level, top.m_7494_()) ? Optional.of(new Apex((Level)level, top.m_7494_())) : Optional.empty();
        apex.ifPresent(Apex::removeBlock);
        int broken = 0;
        for (i = 0; i < quantity; ++i) {
            if (!level.m_46961_(from.m_6630_(i), dropItems)) continue;
            ++broken;
        }
        if (quantity < poleLength) {
            for (int y = from.m_123342_(); y <= top.m_123342_(); ++y) {
                BlockPos dest = GameWorld.Positions.withY(from, y);
                BlockPos source = dest.m_6630_(quantity);
                BlockState placement = level.m_8055_(source);
                if (placement.m_61138_((Property)WATERLOGGED) && IWaterLoggable.isWaterlogged(level.m_8055_(dest))) {
                    placement = (BlockState)placement.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                IPole.replaceWith(placement, level, dest);
            }
        }
        for (i = 0; i < quantity; ++i) {
            level.m_7471_(top.m_6625_(i), false);
        }
        if (apex.isPresent()) {
            ((Apex)apex.get()).restoreAt((Level)level, ((Apex)apex.get()).getPos().m_6625_(quantity));
        }
        return broken;
    }

    default public void playPlaceSound(Level level, BlockPos pos, BlockState state, Player player) {
        SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)player);
        level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
    }

    default public InteractionResult buildBy(Player player, Level level, BlockPos pos, InteractionHand hand, BlockHitResult hit, int quantity) {
        Block heldBlock;
        BlockState heldState;
        if (hit.m_82434_().m_122434_().m_122478_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        UseOnContext context = new UseOnContext(player, hand, hit);
        if (!player.m_7500_()) {
            quantity = Math.min(quantity, heldStack.m_41613_());
        }
        if ((heldState = (heldBlock = Block.m_49814_((Item)heldStack.m_41720_())).m_5573_(new BlockPlaceContext(context))) == null || !this.isPole(heldState)) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int built = this.buildUp(server, pos, heldState, quantity);
            if (built > 0) {
                if (!player.m_7500_()) {
                    heldStack.m_41774_(built);
                }
                this.playPlaceSound(level, pos, heldState, player);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (this.canBuildUp(level, pos)) {
            this.playPlaceSound(level, pos, heldState, player);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    default public void breakBy(Player player, ServerLevel level, BlockPos pos, int quantity) {
        boolean dropItems = !player.m_7500_() && !player.m_5833_();
        this.breakDown(level, pos, quantity, dropItems);
    }

    public static class Apex {
        private final Level level;
        protected final BlockSnapshot snapshot;

        public Apex(Level level, BlockPos pos) {
            this.level = level;
            this.snapshot = BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos);
        }

        public Level getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.snapshot.getPos();
        }

        public void removeBlock() {
            this.getLevel().m_46747_(this.getPos());
            this.getLevel().m_7471_(this.getPos(), false);
        }

        public boolean restoreAt(Level world, BlockPos pos) {
            CompoundTag compound = this.snapshot.getTag();
            if (compound != null) {
                compound.m_128405_("x", pos.m_123341_());
                compound.m_128405_("y", pos.m_123342_());
                compound.m_128405_("z", pos.m_123343_());
            }
            return this.snapshot.restoreToLocation((LevelAccessor)world, pos, true, true);
        }
    }
}

