/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import xfacthd.framedblocks.api.model.SolidFrameMode;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.util.CamoMessageVerbosity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;

public final class ClientConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ClientConfig INSTANCE;
    private static final String KEY_SHOW_GHOST_BLOCKS = "showGhostBlocks";
    private static final String KEY_ALT_GHOST_RENDERER = "altGhostRenderer";
    private static final String KEY_FANCY_HITBOXES = "fancyHitboxes";
    private static final String KEY_DETAILED_CULLING = "detailedCulling";
    private static final String KEY_USE_DISCRETE_UV_STEPS = "discreteUVSteps";
    private static final String KEY_CON_TEX_MODE = "conTexMode";
    private static final String KEY_CAMO_MESSAGE_VERBOSITY = "camoMessageVerbosity";
    private static final String KEY_FORCE_AO_ON_GLOWING_BLOCKS = "forceAoOnGlowingBlocks";
    private static final String KEY_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI = "showAllRecipePermutationsInEmi";
    private static final String KEY_SOLID_FRAME_MODE = "solidFrameMode";
    private static final String KEY_SHOW_BUTTON_PLATE_OVERLAY = "showButtonPlateTypeOverlay";
    private static final String KEY_SHOW_SPECIAL_CUBE_OVERLAY = "showSpecialCubeTypeOverlay";
    private static final String KEY_STATE_LOCK_MODE = "stateLockMode";
    private static final String KEY_TOGGLE_WATERLOG_MODE = "toggleWaterlogMode";
    private static final String KEY_TOGGLE_Y_SLOPE_MODE = "toggleYSlopeMode";
    private static final String KEY_REINFORCEMENT_MODE = "reinforcedMode";
    private static final String KEY_PRISM_OFFSET_MODE = "prismOffsetMode";
    private static final String KEY_SPLIT_LINES_MODE = "splitLineMode";
    private static final String KEY_ONE_WAY_WINDOW_MODE = "oneWayWindowMode";
    private static final String KEY_FRAME_BACKGROUND_MODE = "itemFrameBackgroundMode";
    private static final String KEY_CAMO_ROTATION_MODE = "camoRotationMode";
    public static final String TRANSLATION_SHOW_GHOST_BLOCKS;
    public static final String TRANSLATION_ALT_GHOST_RENDERER;
    public static final String TRANSLATION_FANCY_HITBOXES;
    public static final String TRANSLATION_DETAILED_CULLING;
    public static final String TRANSLATION_USE_DISCRETE_UV_STEPS;
    public static final String TRANSLATION_CON_TEX_MODE;
    public static final String TRANSLATION_CAMO_MESSAGE_VERBOSITY;
    public static final String TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS;
    public static final String TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI;
    public static final String TRANSLATION_SOLID_FRAME_MODE;
    public static final String TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY;
    public static final String TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY;
    public static final String TRANSLATION_STATE_LOCK_MODE;
    public static final String TRANSLATION_TOGGLE_WATERLOG_MODE;
    public static final String TRANSLATION_TOGGLE_Y_SLOPE_MODE;
    public static final String TRANSLATION_REINFORCEMENT_MODE;
    public static final String TRANSLATION_PRISM_OFFSET_MODE;
    public static final String TRANSLATION_SPLIT_LINES_MODE;
    public static final String TRANSLATION_ONE_WAY_WINDOW_MODE;
    public static final String TRANSLATION_FRAME_BACKGROUND_MODE;
    public static final String TRANSLATION_CAMO_ROTATION_MODE;
    private static final String COMMENT_OVERLAY_HIDDEN = "If set to HIDDEN, the %s overlay will be completely hidden";
    private static final String COMMENT_OVERLAY_ICON = "If set to ICON, the %s overlay will only show an icon";
    private static final String COMMENT_OVERLAY_DETAILED = "If set to DETAILED, the %s overlay will show detailed info";
    public static boolean showGhostBlocks;
    public static boolean altGhostRenderer;
    public static boolean fancyHitboxes;
    public static boolean detailedCulling;
    public static boolean useDiscreteUVSteps;
    public static ConTexMode conTexMode;
    public static CamoMessageVerbosity camoMessageVerbosity;
    public static boolean forceAoOnGlowingBlocks;
    public static boolean showAllRecipePermutationsInEmi;
    public static SolidFrameMode solidFrameMode;
    public static boolean showButtonPlateOverlay;
    public static boolean showSpecialCubeOverlay;
    public static BlockInteractOverlay.Mode stateLockMode;
    public static BlockInteractOverlay.Mode toggleWaterlogMode;
    public static BlockInteractOverlay.Mode toggleYSlopeMode;
    public static BlockInteractOverlay.Mode reinforcementMode;
    public static BlockInteractOverlay.Mode prismOffsetMode;
    public static BlockInteractOverlay.Mode splitLineMode;
    public static BlockInteractOverlay.Mode oneWayWindowMode;
    public static BlockInteractOverlay.Mode frameBackgroundMode;
    public static BlockInteractOverlay.Mode camoRotationMode;
    private final ForgeConfigSpec.BooleanValue showGhostBlocksValue;
    private final ForgeConfigSpec.BooleanValue altGhostRendererValue;
    private final ForgeConfigSpec.BooleanValue fancyHitboxesValue;
    private final ForgeConfigSpec.BooleanValue detailedCullingValue;
    private final ForgeConfigSpec.BooleanValue useDiscreteUVStepsValue;
    private final ForgeConfigSpec.EnumValue<ConTexMode> conTexModeValue;
    private final ForgeConfigSpec.EnumValue<CamoMessageVerbosity> camoMessageVerbosityValue;
    private final ForgeConfigSpec.BooleanValue forceAoOnGlowingBlocksValue;
    private final ForgeConfigSpec.BooleanValue showAllRecipePermutationsInEmiValue;
    private final ForgeConfigSpec.EnumValue<SolidFrameMode> solidFrameModeValue;
    private final ForgeConfigSpec.BooleanValue showButtonPlateOverlayValue;
    private final ForgeConfigSpec.BooleanValue showSpecialCubeOverlayValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> stateLockModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> toggleWaterlogModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> toggleYSlopeModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> reinforcementModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> prismOffsetModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> splitLineModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> oneWayWindowModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> frameBackgroundModeValue;
    private final ForgeConfigSpec.EnumValue<BlockInteractOverlay.Mode> camoRotationModeValue;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("general");
        this.showGhostBlocksValue = builder.comment("Whether ghost blocks are shown when you are holding a framed block").translation(TRANSLATION_SHOW_GHOST_BLOCKS).define(KEY_SHOW_GHOST_BLOCKS, true);
        this.altGhostRendererValue = builder.comment("If true, an alternate renderer will be used for the placement preview. May solve issues with certain shaders").translation(TRANSLATION_ALT_GHOST_RENDERER).define(KEY_ALT_GHOST_RENDERER, false);
        this.fancyHitboxesValue = builder.comment("Whether certain framed blocks should show fancy hitboxes").translation(TRANSLATION_FANCY_HITBOXES).define(KEY_FANCY_HITBOXES, true);
        this.detailedCullingValue = builder.comment("If false only full block faces of framed blocks will be culled, if true all outer faces of famed blocks can be culled").translation(TRANSLATION_DETAILED_CULLING).define(KEY_DETAILED_CULLING, true);
        this.useDiscreteUVStepsValue = builder.comment("If true, the UV remapping will use discrete steps to avoid floating point errors").translation(TRANSLATION_USE_DISCRETE_UV_STEPS).define(KEY_USE_DISCRETE_UV_STEPS, true);
        this.conTexModeValue = builder.comment(new String[]{"Configures how detailed connected textures are supported.", "Use anything above FULL_EDGE at your own risk (performance impact, unexpected behaviour)!", "If NONE, all connected textures support is disabled", "If FULL_FACE, connected textures are supported on full faces", "If FULL_EDGE, connected textures are supported as above and on faces whose connecting edge covers the full block width", "If DETAILED, connected textures are supported as above and on most faces when interacting with other framed blocks"}).translation(TRANSLATION_CON_TEX_MODE).defineEnum(KEY_CON_TEX_MODE, (Enum)ConTexMode.FULL_FACE);
        this.camoMessageVerbosityValue = builder.comment(new String[]{"Configures the verbosity of messages displayed when a block cannot be used as a camo", "If NONE, no message will be shown", "If DEFAULT, a message will be shown when the block has a BlockEntity and isn't explicitly allowed or the block is explicitly disallowed", "If DETAILED, a message will be shown as above or when a block is non-solid and not explicitly allowed"}).translation(TRANSLATION_CAMO_MESSAGE_VERBOSITY).defineEnum(KEY_CAMO_MESSAGE_VERBOSITY, (Enum)CamoMessageVerbosity.DEFAULT);
        this.forceAoOnGlowingBlocksValue = builder.comment(new String[]{"If true, ambient occlusion is applied to framed blocks which glow from applied glowstone dust.", "If false, the vanilla behavior of disabling AO for light-emitting blocks is used"}).translation(TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS).define(KEY_FORCE_AO_ON_GLOWING_BLOCKS, true);
        this.showAllRecipePermutationsInEmiValue = builder.comment("If true, all possible recipes of the Framing Saw will be added to EMI, else only the permutations using the Framed Cube will be added").comment("This setting only has an effect when EMI is installed").translation(TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI).define(KEY_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI, true);
        this.solidFrameModeValue = builder.comment(new String[]{"Configures in which cases a framed block without a camo gets a solid model", "If NEVER, the default frame texture will always be used", "If DEFAULT, certain blocks will use the default frame texture with a solid background texture", "If ALWAYS, all blocks will use the default frame texture with a solid background texture"}).translation(TRANSLATION_SOLID_FRAME_MODE).defineEnum(KEY_SOLID_FRAME_MODE, (Enum)SolidFrameMode.DEFAULT);
        this.showButtonPlateOverlayValue = builder.comment(new String[]{"If enabled, non-wooden buttons and pressure plates will show a material overlay when a camo is applied", "Requires resource reload to take effect"}).translation(TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY).define(KEY_SHOW_BUTTON_PLATE_OVERLAY, true);
        this.showSpecialCubeOverlayValue = builder.comment(new String[]{"If enabled, special cube blocks will show a type overlay when a camo is applied", "Requires resource reload to take effect"}).translation(TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY).define(KEY_SHOW_SPECIAL_CUBE_OVERLAY, true);
        builder.pop();
        builder.push("overlay");
        this.stateLockModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("State Lock")).comment(COMMENT_OVERLAY_ICON.formatted("State Lock")).comment(COMMENT_OVERLAY_DETAILED.formatted("State Lock")).translation(TRANSLATION_STATE_LOCK_MODE).defineEnum(KEY_STATE_LOCK_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.toggleWaterlogModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Toggle Waterloggable")).comment(COMMENT_OVERLAY_ICON.formatted("Toggle Waterloggable")).comment(COMMENT_OVERLAY_DETAILED.formatted("Toggle Waterloggable")).translation(TRANSLATION_TOGGLE_WATERLOG_MODE).defineEnum(KEY_TOGGLE_WATERLOG_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.toggleYSlopeModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Toggle Slope Face")).comment(COMMENT_OVERLAY_ICON.formatted("Toggle Slope Face")).comment(COMMENT_OVERLAY_DETAILED.formatted("Toggle Slope Face")).translation(TRANSLATION_TOGGLE_Y_SLOPE_MODE).defineEnum(KEY_TOGGLE_Y_SLOPE_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.reinforcementModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Reinforcement")).comment(COMMENT_OVERLAY_ICON.formatted("Reinforcement")).comment(COMMENT_OVERLAY_DETAILED.formatted("Reinforcement")).translation(TRANSLATION_REINFORCEMENT_MODE).defineEnum(KEY_REINFORCEMENT_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.prismOffsetModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Prism Offset")).comment(COMMENT_OVERLAY_ICON.formatted("Prism Offset")).comment(COMMENT_OVERLAY_DETAILED.formatted("Prism Offset")).translation(TRANSLATION_PRISM_OFFSET_MODE).defineEnum(KEY_PRISM_OFFSET_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.splitLineModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Collapsible Block Split Line")).comment(COMMENT_OVERLAY_ICON.formatted("Collapsible Block Split Line")).comment(COMMENT_OVERLAY_DETAILED.formatted("Collapsible Block Split Line")).translation(TRANSLATION_SPLIT_LINES_MODE).defineEnum(KEY_SPLIT_LINES_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.oneWayWindowModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("One-Way Window")).comment(COMMENT_OVERLAY_ICON.formatted("One-Way Window")).comment(COMMENT_OVERLAY_DETAILED.formatted("One-Way Window")).translation(TRANSLATION_ONE_WAY_WINDOW_MODE).defineEnum(KEY_ONE_WAY_WINDOW_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.frameBackgroundModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Item Frame Background")).comment(COMMENT_OVERLAY_ICON.formatted("Item Frame Background")).comment(COMMENT_OVERLAY_DETAILED.formatted("Item Frame Background")).translation(TRANSLATION_FRAME_BACKGROUND_MODE).defineEnum(KEY_FRAME_BACKGROUND_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        this.camoRotationModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Camo Rotation")).comment(COMMENT_OVERLAY_ICON.formatted("Camo Rotation")).comment(COMMENT_OVERLAY_DETAILED.formatted("Camo Rotation")).translation(TRANSLATION_CAMO_ROTATION_MODE).defineEnum(KEY_CAMO_ROTATION_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        builder.pop();
    }

    private static String translate(String key) {
        return Utils.translateConfig("client", key);
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && event.getConfig().getSpec() == SPEC) {
            showGhostBlocks = (Boolean)this.showGhostBlocksValue.get();
            altGhostRenderer = (Boolean)this.altGhostRendererValue.get();
            fancyHitboxes = (Boolean)this.fancyHitboxesValue.get();
            detailedCulling = (Boolean)this.detailedCullingValue.get();
            useDiscreteUVSteps = (Boolean)this.useDiscreteUVStepsValue.get();
            conTexMode = (ConTexMode)((Object)this.conTexModeValue.get());
            camoMessageVerbosity = (CamoMessageVerbosity)((Object)this.camoMessageVerbosityValue.get());
            forceAoOnGlowingBlocks = (Boolean)this.forceAoOnGlowingBlocksValue.get();
            showAllRecipePermutationsInEmi = (Boolean)this.showAllRecipePermutationsInEmiValue.get();
            solidFrameMode = (SolidFrameMode)((Object)this.solidFrameModeValue.get());
            showButtonPlateOverlay = (Boolean)this.showButtonPlateOverlayValue.get();
            showSpecialCubeOverlay = (Boolean)this.showSpecialCubeOverlayValue.get();
            stateLockMode = (BlockInteractOverlay.Mode)((Object)this.stateLockModeValue.get());
            toggleWaterlogMode = (BlockInteractOverlay.Mode)((Object)this.toggleWaterlogModeValue.get());
            toggleYSlopeMode = (BlockInteractOverlay.Mode)((Object)this.toggleYSlopeModeValue.get());
            reinforcementMode = (BlockInteractOverlay.Mode)((Object)this.reinforcementModeValue.get());
            prismOffsetMode = (BlockInteractOverlay.Mode)((Object)this.prismOffsetModeValue.get());
            splitLineMode = (BlockInteractOverlay.Mode)((Object)this.splitLineModeValue.get());
            oneWayWindowMode = (BlockInteractOverlay.Mode)((Object)this.oneWayWindowModeValue.get());
            frameBackgroundMode = (BlockInteractOverlay.Mode)((Object)this.frameBackgroundModeValue.get());
            camoRotationMode = (BlockInteractOverlay.Mode)((Object)this.camoRotationModeValue.get());
        }
    }

    static {
        TRANSLATION_SHOW_GHOST_BLOCKS = ClientConfig.translate(KEY_SHOW_GHOST_BLOCKS);
        TRANSLATION_ALT_GHOST_RENDERER = ClientConfig.translate(KEY_ALT_GHOST_RENDERER);
        TRANSLATION_FANCY_HITBOXES = ClientConfig.translate(KEY_FANCY_HITBOXES);
        TRANSLATION_DETAILED_CULLING = ClientConfig.translate(KEY_DETAILED_CULLING);
        TRANSLATION_USE_DISCRETE_UV_STEPS = ClientConfig.translate(KEY_USE_DISCRETE_UV_STEPS);
        TRANSLATION_CON_TEX_MODE = ClientConfig.translate(KEY_CON_TEX_MODE);
        TRANSLATION_CAMO_MESSAGE_VERBOSITY = ClientConfig.translate(KEY_CAMO_MESSAGE_VERBOSITY);
        TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS = ClientConfig.translate(KEY_FORCE_AO_ON_GLOWING_BLOCKS);
        TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI = ClientConfig.translate(KEY_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI);
        TRANSLATION_SOLID_FRAME_MODE = ClientConfig.translate(KEY_SOLID_FRAME_MODE);
        TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY = ClientConfig.translate(KEY_SHOW_BUTTON_PLATE_OVERLAY);
        TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY = ClientConfig.translate(KEY_SHOW_SPECIAL_CUBE_OVERLAY);
        TRANSLATION_STATE_LOCK_MODE = ClientConfig.translate(KEY_STATE_LOCK_MODE);
        TRANSLATION_TOGGLE_WATERLOG_MODE = ClientConfig.translate(KEY_TOGGLE_WATERLOG_MODE);
        TRANSLATION_TOGGLE_Y_SLOPE_MODE = ClientConfig.translate(KEY_TOGGLE_Y_SLOPE_MODE);
        TRANSLATION_REINFORCEMENT_MODE = ClientConfig.translate(KEY_REINFORCEMENT_MODE);
        TRANSLATION_PRISM_OFFSET_MODE = ClientConfig.translate(KEY_PRISM_OFFSET_MODE);
        TRANSLATION_SPLIT_LINES_MODE = ClientConfig.translate(KEY_SPLIT_LINES_MODE);
        TRANSLATION_ONE_WAY_WINDOW_MODE = ClientConfig.translate(KEY_ONE_WAY_WINDOW_MODE);
        TRANSLATION_FRAME_BACKGROUND_MODE = ClientConfig.translate(KEY_FRAME_BACKGROUND_MODE);
        TRANSLATION_CAMO_ROTATION_MODE = ClientConfig.translate(KEY_CAMO_ROTATION_MODE);
        showGhostBlocks = false;
        altGhostRenderer = false;
        fancyHitboxes = false;
        detailedCulling = false;
        useDiscreteUVSteps = false;
        conTexMode = ConTexMode.FULL_FACE;
        camoMessageVerbosity = CamoMessageVerbosity.DEFAULT;
        forceAoOnGlowingBlocks = false;
        showAllRecipePermutationsInEmi = false;
        solidFrameMode = SolidFrameMode.DEFAULT;
        showButtonPlateOverlay = false;
        showSpecialCubeOverlay = false;
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (ClientConfig)configSpecPair.getLeft();
    }
}

