/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.event.levelstage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import nuclearscience.common.tile.TileCloudChamber;
import org.joml.Matrix4f;
import voltaic.client.event.AbstractLevelStageHandler;

public class HandlerCloudChamber
extends AbstractLevelStageHandler {
    public static final HandlerCloudChamber INSTANCE = new HandlerCloudChamber();
    private HashSet<TileCloudChamber> locations = new HashSet();

    public boolean shouldRender(RenderLevelStageEvent.Stage stage) {
        return stage == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS;
    }

    public void render(Camera camera, Frustum frustum, LevelRenderer renderer, PoseStack poseStack, Matrix4f projectionMatrix, Minecraft minecraft, int renderTick, float partialTick) {
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        Vec3 camPos = camera.m_90583_();
        Iterator<TileCloudChamber> it = this.locations.iterator();
        while (it.hasNext()) {
            TileCloudChamber chamber = it.next();
            if (chamber == null || chamber.m_58901_() || !chamber.m_58898_() || !chamber.m_58904_().m_46749_(chamber.m_58899_()) || !((Boolean)chamber.active.getValue()).booleanValue()) {
                it.remove();
                continue;
            }
            ((List)chamber.sources.getValue()).forEach(source -> {
                AABB outline = new AABB(source);
                if (!frustum.m_113029_(outline)) {
                    return;
                }
                poseStack.m_85836_();
                poseStack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)builder, (AABB)outline, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85849_();
            });
        }
        buffer.m_109912_((RenderType)RenderType.f_110371_);
    }

    public void clear() {
        this.locations.clear();
    }

    public static void addSources(TileCloudChamber chamber) {
        HandlerCloudChamber.INSTANCE.locations.add(chamber);
    }

    public static void removeSources(TileCloudChamber chamber) {
        HandlerCloudChamber.INSTANCE.locations.remove((Object)chamber);
    }
}

