/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentProgress;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.object.TransferPack;

public class ScreenRadioisotopeGenerator
extends GenericScreen<ContainerRadioisotopeGenerator> {
    public ScreenRadioisotopeGenerator(ContainerRadioisotopeGenerator container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentProgress(ScreenComponentProgress.ProgressBars.COUNTDOWN_FLAME, () -> {
            ItemStack in = container.m_38853_(0).m_7993_();
            RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.m_41720_());
            double currentOutput = (double)in.m_41613_() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.amount();
            if (currentOutput > 0.0) {
                return 1.0;
            }
            return 0.0;
        }, 25, 24));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getEnergyInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            ItemStack in = ((ContainerRadioisotopeGenerator)this.f_97732_).m_38853_(0).m_7993_();
            RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.m_41720_());
            double currentOutput = (double)in.m_41613_() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.amount();
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE);
            graphics.m_280614_(this.f_96547_, (Component)NuclearTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)transfer.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)), this.f_97730_ + 60, this.f_97731_ - 48, Color.TEXT_GRAY.color(), false);
            graphics.m_280614_(this.f_96547_, (Component)NuclearTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)transfer.getWatts(), (IDisplayUnit)DisplayUnits.WATT)), this.f_97730_ + 60, this.f_97731_ - 35, Color.TEXT_GRAY.color(), false);
            graphics.m_280614_(this.f_96547_, (Component)NuclearTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)transfer.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)), this.f_97730_ + 60, this.f_97731_ - 22, Color.TEXT_GRAY.color(), false);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
    }

    private List<? extends FormattedCharSequence> getEnergyInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        ItemStack in = ((ContainerRadioisotopeGenerator)this.f_97732_).m_38853_(0).m_7993_();
        RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.m_41720_());
        double currentOutput = (double)in.m_41613_() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.amount();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE);
        list.add(NuclearTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)transfer.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(NuclearTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)transfer.getWatts(), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(NuclearTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)transfer.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

