/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.platform.InputConstants;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IClickable
extends IDrawableRect {
    @Override
    default public void moveBy(double x, double y) {
        this.moveBy(new MusePoint2D(x, y));
    }

    @Override
    default public void moveBy(MusePoint2D amount) {
        this.setPosition(this.center().plus(amount));
    }

    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public void setVisible(boolean var1);

    public boolean isVisible();

    default public void hide() {
        this.setVisible(false);
    }

    default public void show() {
        this.setVisible(true);
    }

    default public void enable() {
        this.setEnabled(true);
    }

    default public void disable() {
        this.setEnabled(false);
    }

    default public void enableAndShow() {
        this.enable();
        this.show();
    }

    default public void disableAndHide() {
        this.disable();
        this.hide();
    }

    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible() && this.containsPoint(mouseX, mouseY)) {
            InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(button);
            boolean flag = Minecraft.m_91087_().f_91066_.f_92097_.isActiveAndMatches(mouseKey);
            if (button == 0 || button == 1 || flag) {
                this.onPressed();
            }
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return false;
    }

    default public void playDownSound(SoundManager soundHandler) {
        soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible()) {
            InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(button);
            boolean flag = Minecraft.m_91087_().f_91066_.f_92097_.isActiveAndMatches(mouseKey);
            if (button == 0 || button == 1 || flag) {
                this.onReleased();
            }
        }
        return false;
    }

    public void setOnPressed(IPressable var1);

    public void setOnReleased(IReleasable var1);

    public void onPressed();

    public void onReleased();

    default public Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IReleasable {
        public void onReleased(IClickable var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPressed(IClickable var1);
    }
}

