/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lehjr.numina.client.gui.NuminaIcons;
import lehjr.numina.client.render.NuminaSpriteUploader;
import lehjr.numina.common.constants.NuminaConstants;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public enum IconUtils {
    INSTANCE;

    private NuminaIcons icon;
    public static final Map<EquipmentSlot, ResourceLocation> ARMOR_SLOT_TEXTURES;

    public NuminaIcons getIcon() {
        if (IconUtils.INSTANCE.icon == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            TextureManager textureManager = minecraft.m_91097_();
            NuminaSpriteUploader spriteUploader = new NuminaSpriteUploader(textureManager);
            IconUtils.INSTANCE.icon = new NuminaIcons(spriteUploader);
        }
        return IconUtils.INSTANCE.icon;
    }

    static TextureAtlasSprite getMissingIcon() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    public static void drawIconAt(double x, double y, @Nonnull TextureAtlasSprite icon, Color color) {
        IconUtils.drawIconPartial(x, y, icon, color, 0.0, 0.0, 16.0, 16.0);
    }

    public static void drawIconAt(PoseStack poseStack, double x, double y, @Nonnull TextureAtlasSprite icon, Color color) {
        IconUtils.drawIconPartial(poseStack, x, y, icon, color, 0.0, 0.0, icon.m_245424_().m_246492_(), icon.m_245424_().m_245330_());
    }

    public static void drawIconPartialOccluded(double x, double y, @Nonnull TextureAtlasSprite icon, Color color, double textureStarX, double textureStartY, double textureEndX, double textureEndY) {
        double xmin = MathUtils.clampDouble(textureStarX - x, 0.0, icon.m_245424_().m_246492_());
        double ymin = MathUtils.clampDouble(textureStartY - y, 0.0, icon.m_245424_().m_245330_());
        double xmax = MathUtils.clampDouble(textureEndX - x, 0.0, icon.m_245424_().m_246492_());
        double ymax = MathUtils.clampDouble(textureEndY - y, 0.0, icon.m_245424_().m_245330_());
        IconUtils.drawIconPartial(x, y, icon, color, xmin, ymin, xmax, ymax);
    }

    public static void drawIconPartial(PoseStack poseStack, double posX, double posY, TextureAtlasSprite icon, @Nonnull Color color, double textureStartX, double textureStartY, double textureEndX, double textureEndY) {
        if (icon == null) {
            icon = IconUtils.getMissingIcon();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.m_247685_());
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tess.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float iconWidthDiv = 1.0f / (float)icon.m_245424_().m_246492_();
        float icomHeightDiv = 1.0f / (float)icon.m_245424_().m_245330_();
        double xoffsetMin = textureStartX * (double)(maxU - minU) * (double)iconWidthDiv;
        double xoffsetMax = textureEndX * (double)(maxU - minU) * (double)iconWidthDiv;
        double yoffsetMin = textureStartY * (double)(maxV - minV) * (double)icomHeightDiv;
        double yoffsetMax = textureEndY * (double)(maxV - minV) * (double)icomHeightDiv;
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix4f, (float)(posX + textureStartX), (float)(posY + textureStartY), 0.0f);
        bufferBuilder.m_7421_((float)((double)minU + xoffsetMin), (float)((double)minV + yoffsetMin));
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(posX + textureStartX), (float)(posY + textureEndY), 0.0f);
        bufferBuilder.m_7421_((float)((double)minU + xoffsetMin), (float)((double)minV + yoffsetMax));
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(posX + textureEndX), (float)(posY + textureEndY), 0.0f);
        bufferBuilder.m_7421_((float)((double)minU + xoffsetMax), (float)((double)minV + yoffsetMax));
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(posX + textureEndX), (float)(posY + textureStartY), 0.0f);
        bufferBuilder.m_7421_((float)((double)minU + xoffsetMax), (float)((double)minV + yoffsetMin));
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void drawIconPartial(double x, double y, TextureAtlasSprite icon, Color color, double left, double top, double right, double bottom) {
        if (icon == null) {
            icon = IconUtils.getMissingIcon();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.m_247685_());
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tess.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        double uMin = icon.m_118409_();
        double vMin = icon.m_118411_();
        double uMax = icon.m_118410_();
        double vMax = icon.m_118412_();
        double xoffset1 = left * (uMax - uMin) / 16.0;
        double yoffset1 = top * (vMax - vMin) / 16.0;
        double xoffset2 = right * (uMax - uMin) / 16.0;
        double yoffset2 = bottom * (vMax - vMin) / 16.0;
        bufferBuilder.m_5483_(x + left, y + top, 0.0);
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_7421_((float)(uMin + xoffset1), (float)(vMin + yoffset1));
        bufferBuilder.m_5752_();
        bufferBuilder.m_5483_(x + left, y + bottom, 0.0);
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_7421_((float)(uMin + xoffset1), (float)(vMin + yoffset2));
        bufferBuilder.m_5752_();
        bufferBuilder.m_5483_(x + right, y + bottom, 0.0);
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_7421_((float)(uMin + xoffset2), (float)(vMin + yoffset2));
        bufferBuilder.m_5752_();
        bufferBuilder.m_5483_(x + right, y + top, 0.0);
        bufferBuilder.m_85950_(color.r, color.g, color.b, color.a);
        bufferBuilder.m_7421_((float)(uMin + xoffset2), (float)(vMin + yoffset1));
        bufferBuilder.m_5752_();
        tess.m_85914_();
    }

    public static void blit(PoseStack matrixStack, double posX, double posY, double pBlitOffset, double drawWidth, double drawHeight, TextureAtlasSprite pSprite) {
        IconUtils.innerBlit(matrixStack.m_85850_().m_252922_(), posX, posX + drawWidth, posY, posY + drawHeight, pBlitOffset, pSprite.m_118409_(), pSprite.m_118410_(), pSprite.m_118411_(), pSprite.m_118412_());
    }

    public void blit(PoseStack pPoseStack, double posX, double posY, double uOffset, double vOffset, double uWidth, double vHeight) {
        IconUtils.blit(pPoseStack, posX, posY, this.getBlitOffset(), uOffset, vOffset, uWidth, vHeight, 256.0, 256.0);
    }

    public static void blit(PoseStack pPoseStack, double posX, double posY, double blitOffset, double uOffset, double vOffset, double uWidth, double vHeight, double textureHeight, double textureWidth) {
        IconUtils.innerBlit(pPoseStack, posX, posX + uWidth, posY, posY + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void blit(PoseStack pPoseStack, double posX, double posY, double pBlitOffset, double pUOffset, double vOffset, double uWidth, double pVHeight, double textureHeight, double textureWidth, Color color) {
        IconUtils.innerBlit(pPoseStack, posX, posX + uWidth, posY, posY + pVHeight, pBlitOffset, uWidth, pVHeight, pUOffset, vOffset, textureWidth, textureHeight, color);
    }

    public static void blit(PoseStack pPoseStack, double drawStartX, double drawStartY, double pUOffset, double pVOffset, double pWidth, double pHeight, double textureWidth, double textureHeight) {
        IconUtils.blit(pPoseStack, drawStartX, drawStartY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, textureWidth, textureHeight);
    }

    public static void blit(PoseStack pPoseStack, double drawStartX, double drawStartY, double drawWidth, double drawHeight, double uOffset, double vOffset, double uWidth, double vHeight, double textureWidth, double textureHeight) {
        IconUtils.innerBlit(pPoseStack, drawStartX, drawStartX + drawWidth, drawStartY, drawStartY + drawHeight, 0.0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public static void innerBlit(PoseStack pPoseStack, double posX, double pX2, double pY1, double pY2, double pBlitOffset, double uWidth, double vHeight, double uOffset, double vOffset, double textureWidth, double textureHeight) {
        IconUtils.innerBlit(pPoseStack.m_85850_().m_252922_(), posX, pX2, pY1, pY2, pBlitOffset, (uOffset + 0.0) / textureWidth, (uOffset + uWidth) / textureWidth, (vOffset + 0.0) / textureHeight, (vOffset + vHeight) / textureHeight);
    }

    public static void innerBlit(Matrix4f matrix4f, double drawStartX, double drawEndX, double drawStartY, double drawEndY, double blitOffset, double uMin, double uMax, double vMin, double vMax) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)drawStartX, (float)drawEndY, (float)blitOffset).m_7421_((float)uMin, (float)vMax).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)drawEndX, (float)drawEndY, (float)blitOffset).m_7421_((float)uMax, (float)vMax).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)drawEndX, (float)drawStartY, (float)blitOffset).m_7421_((float)uMax, (float)vMin).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)drawStartX, (float)drawStartY, (float)blitOffset).m_7421_((float)uMin, (float)vMin).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void blit(PoseStack matrixStack, double posX, double posY, double pBlitOffset, double drawWidth, double drawHeight, TextureAtlasSprite sprite, Color color) {
        IconUtils.innerBlit(matrixStack.m_85850_().m_252922_(), posX, posX + drawWidth, posY, posY + drawHeight, pBlitOffset, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), color);
    }

    public void blit(PoseStack pPoseStack, double posX, double posY, double uOffset, double vOffset, double uWidth, double vHeight, Color color) {
        IconUtils.blit(pPoseStack, posX, posY, this.getBlitOffset(), uOffset, vOffset, uWidth, vHeight, 256.0, 256.0, color);
    }

    public static void blit(PoseStack pPoseStack, double posX, double posY, double pUOffset, double pVOffset, double pWidth, double pHeight, double textureWidth, double textureHeight, Color color) {
        IconUtils.blit(pPoseStack, posX, posY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, textureWidth, textureHeight, color);
    }

    public static void blit(PoseStack pPoseStack, double posX, double posY, double drawWidth, double drawHeight, double uOffset, double vOffset, double uWidth, double vHeight, double textureWidth, double textureHeight, Color color) {
        IconUtils.innerBlit(pPoseStack, posX, posX + drawWidth, posY, posY + drawHeight, 0.0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight, color);
    }

    public static void innerBlit(PoseStack pPoseStack, double drawStartX, double drawEndX, double drawStartY, double drawEndY, double blitOffset, double uWidth, double vHeight, double uOffset, double vOffset, double textureWidth, double textureHeight, Color color) {
        IconUtils.innerBlit(pPoseStack.m_85850_().m_252922_(), drawStartX, drawEndX, drawStartY, drawEndY, blitOffset, uOffset / textureWidth, (uOffset + uWidth) / textureWidth, vOffset / textureHeight, (vOffset + vHeight) / textureHeight, color);
    }

    public static void innerBlit(Matrix4f matrix4f, double drawStartX, double drawEndX, double drawStartY, double drawEndY, double blitOffset, double uMin, double uMax, double vMin, double vMax, Color color) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix4f, (float)drawStartX, (float)drawEndY, (float)blitOffset).m_7421_((float)uMin, (float)vMax).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)drawEndX, (float)drawEndY, (float)blitOffset).m_7421_((float)uMax, (float)vMax).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)drawEndX, (float)drawStartY, (float)blitOffset).m_7421_((float)uMax, (float)vMin).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)drawStartX, (float)drawStartY, (float)blitOffset).m_7421_((float)uMin, (float)vMin).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    double getBlitOffset() {
        return 0.0;
    }

    Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    public static final Pair<ResourceLocation, ResourceLocation> getSlotBackground(EquipmentSlot slotType) {
        switch (slotType) {
            case MAINHAND: {
                return Pair.of((Object)NuminaConstants.LOCATION_NUMINA_GUI_TEXTURE_ATLAS, (Object)ARMOR_SLOT_TEXTURES.get(slotType));
            }
        }
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES.get(slotType));
    }

    static {
        ARMOR_SLOT_TEXTURES = new HashMap<EquipmentSlot, ResourceLocation>(){
            {
                this.put(EquipmentSlot.HEAD, InventoryMenu.f_39693_);
                this.put(EquipmentSlot.CHEST, InventoryMenu.f_39694_);
                this.put(EquipmentSlot.LEGS, InventoryMenu.f_39695_);
                this.put(EquipmentSlot.FEET, InventoryMenu.f_39696_);
                this.put(EquipmentSlot.OFFHAND, InventoryMenu.f_39697_);
                this.put(EquipmentSlot.MAINHAND, NuminaConstants.WEAPON_SLOT_BACKGROUND);
            }
        };
    }
}

