/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.CapabilityUpdate;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModule;
import lehjr.numina.common.config.NuminaSettings;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class BatteryCapabilityProvider
implements ICapabilityProvider {
    public final PowerModule powerModule;
    private final ModuleEnergyWrapper energyStorage;
    private final LazyOptional<IPowerModule> powerModuleHolder;
    private final LazyOptional<IEnergyStorage> energyStorageHolder;

    public BatteryCapabilityProvider(ItemStack module, final int tier, final int maxEnergy, final int maxTransfer) {
        this.powerModule = new PowerModule(module, ModuleCategory.ENERGY_STORAGE, ModuleTarget.ALLITEMS, NuminaSettings::getModuleConfig){
            {
                super(module, category, target, moduleConfigGetterIn);
                this.addBaseProperty("maxEnergy", maxEnergy, "FE");
                this.addBaseProperty("maxTransfer", maxTransfer, "FE");
            }

            @Override
            public int getTier() {
                return tier;
            }

            @Override
            public String getModuleGroup() {
                return "Battery";
            }
        };
        this.powerModuleHolder = LazyOptional.of(() -> this.powerModule);
        this.energyStorage = new ModuleEnergyWrapper(module, (int)this.powerModule.applyPropertyModifiers("maxEnergy"), (int)this.powerModule.applyPropertyModifiers("maxTransfer"));
        this.energyStorageHolder = LazyOptional.of(() -> {
            this.energyStorage.loadCapValues();
            return this.energyStorage;
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional capabilityPowerModule = NuminaCapabilities.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
        if (capabilityPowerModule.isPresent()) {
            return capabilityPowerModule;
        }
        LazyOptional energyCapability = ForgeCapabilities.ENERGY.orEmpty(capability, this.energyStorageHolder);
        if (energyCapability.isPresent()) {
            return energyCapability;
        }
        return LazyOptional.empty();
    }

    public void setMaxEnergy() {
        this.energyStorage.deserializeNBT((Tag)IntTag.m_128679_((int)this.energyStorage.getMaxEnergyStored()));
        this.energyStorage.onValueChanged();
    }

    class ModuleEnergyWrapper
    extends EnergyStorage
    implements CapabilityUpdate {
        @Nonnull
        ItemStack module;

        public ModuleEnergyWrapper(ItemStack module, int maxEnergy, int maxTransfer) {
            super(maxEnergy, maxTransfer);
            this.module = module;
        }

        @Override
        public void loadCapValues() {
            CompoundTag nbt = TagUtils.getModuleTag(this.module);
            if (nbt.m_128425_("energy", 3)) {
                this.deserializeNBT(nbt.m_128423_("energy"));
            }
        }

        @Override
        public void onValueChanged() {
            CompoundTag nbt = TagUtils.getModuleTag(this.module);
            if (nbt != null && ForgeCapabilities.ENERGY != null) {
                nbt.m_128365_("energy", this.serializeNBT());
            }
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyReceived = (int)Math.min((double)(this.getMaxEnergyStored() - this.energy), Math.min(BatteryCapabilityProvider.this.powerModuleHolder.map(pm -> pm.applyPropertyModifiers("maxTransfer")).orElse(0.0), (double)maxReceive));
            if (!simulate && energyReceived != 0) {
                this.energy += energyReceived;
                this.onValueChanged();
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energyExtracted = Math.min(this.energy, Math.min((int)BatteryCapabilityProvider.this.powerModule.applyPropertyModifiers("maxTransfer"), maxExtract));
            if (!simulate && energyExtracted != 0) {
                this.energy -= energyExtracted;
                this.onValueChanged();
            }
            return energyExtracted;
        }

        public int getMaxEnergyStored() {
            double ret = BatteryCapabilityProvider.this.powerModuleHolder.map(pm -> pm.applyPropertyModifiers("maxEnergy")).orElse(0.0);
            return (int)ret;
        }

        public boolean canExtract() {
            return (int)BatteryCapabilityProvider.this.powerModule.applyPropertyModifiers("maxTransfer") > 0;
        }

        public boolean canReceive() {
            return (int)BatteryCapabilityProvider.this.powerModule.applyPropertyModifiers("maxTransfer") > 0;
        }
    }
}

