/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.common.capabilities.render.modelspec.SpecBase;
import lehjr.numina.common.map.NuminaRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class NuminaModelSpecRegistry
extends NuminaRegistry<SpecBase> {
    private static volatile NuminaModelSpecRegistry INSTANCE;

    private NuminaModelSpecRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NuminaModelSpecRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<NuminaModelSpecRegistry> clazz = NuminaModelSpecRegistry.class;
        synchronized (NuminaModelSpecRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new NuminaModelSpecRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Iterable<SpecBase> getSpecs() {
        return this.elems();
    }

    public Stream<SpecBase> getSpecsAsStream() {
        return this.elemsAsStream();
    }

    public NonNullList<SpecBase> getSpecsForArmorEquipmentSlot(EquipmentSlot slot) {
        NonNullList ret = NonNullList.m_122779_();
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.elemsAsStream().filter(specBase -> specBase.hasArmorEquipmentSlot(slot)).forEach(specBase -> ret.add(specBase));
        }
        return ret;
    }

    public NonNullList<SpecBase> getSpecsForHand(HumanoidArm arm, LivingEntity entity) {
        NonNullList ret = NonNullList.m_122779_();
        this.elemsAsStream().filter(specBase -> specBase.elemsAsStream().filter(partSpecBase -> partSpecBase.isForHand(arm, entity)).findFirst().isPresent()).forEach(specBase -> ret.add(specBase));
        return ret;
    }

    public Iterable<String> getNames() {
        return this.names();
    }

    public SpecBase getModel(CompoundTag nbt) {
        return (SpecBase)this.get(nbt.m_128461_("model"));
    }

    public PartSpecBase getPart(CompoundTag nbt, SpecBase model) {
        if (model == null) {
            return null;
        }
        return (PartSpecBase)model.get(nbt.m_128461_("part"));
    }

    public PartSpecBase getPart(CompoundTag nbt) {
        return this.getPart(nbt, this.getModel(nbt));
    }

    public boolean addPart(PartSpecBase part) {
        try {
            String baseName = part.spec.getOwnName();
            NuminaLogger.logDebug("adding part < " + part.partName + " > for model < " + baseName + " >");
            SpecBase base = (SpecBase)this.get(baseName);
            base.put(part, part.partName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    public CompoundTag getSpecTag(CompoundTag renderTag, PartSpecBase spec) {
        String name = this.makeName(spec);
        return renderTag.m_128441_(name) ? renderTag.m_128469_(name) : null;
    }

    public String makeName(PartSpecBase spec) {
        return spec.spec.getOwnName() + "." + spec.partName;
    }
}

