/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.event;

import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.heat.HeatUtils;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.player.PlayerUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerUpdateHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        double currHeat;
        Player player = event.player;
        NonNullList modularItems = NonNullList.m_122779_();
        block6: for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (ItemUtils.getItemFromEntitySlot((LivingEntity)player, slot).m_41619_()) continue;
            switch (slot.m_20743_()) {
                case HAND: {
                    ItemUtils.getItemFromEntitySlot((LivingEntity)player, slot).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(i -> {
                        i.tick(player);
                        modularItems.add((Object)i.getModularItemStack());
                    });
                    continue block6;
                }
                case ARMOR: {
                    try {
                        ItemUtils.getItemFromEntitySlot((LivingEntity)player, slot).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(i -> {
                            i.tick(player);
                            modularItems.add((Object)i.getModularItemStack());
                        });
                        continue block6;
                    }
                    catch (Exception exception) {
                        NuminaLogger.logException(ItemUtils.getItemFromEntitySlot((LivingEntity)player, slot).toString(), exception);
                    }
                }
            }
        }
        if (!modularItems.isEmpty() && (currHeat = HeatUtils.getPlayerHeat((LivingEntity)player)) >= 0.0 && !player.m_9236_().f_46443_) {
            double maxHeat;
            double coolPlayerAmount = (double)PlayerUtils.getPlayerCoolingBasedOnMaterial(player) * 0.55;
            if (coolPlayerAmount > 0.0) {
                HeatUtils.coolPlayer((LivingEntity)player, coolPlayerAmount);
            }
            if (currHeat < (maxHeat = HeatUtils.getPlayerMaxHeat((LivingEntity)player)) * 0.95) {
                player.m_20095_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void entityAttackEventHandler(LivingAttackEvent event) {
        if (event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
            HeatUtils.heatEntity(event);
        }
    }
}

