/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets.serverbound;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.clientbound.TweakRequestDoublePacketClientBound;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record TweakRequestDoublePacketServerBound(EquipmentSlot type, ResourceLocation moduleRegName, String tweakName, double tweakValue) {
    public static void encode(TweakRequestDoublePacketServerBound msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)msg.type);
        packetBuffer.m_130085_(msg.moduleRegName);
        packetBuffer.m_130070_(msg.tweakName);
        packetBuffer.writeDouble(msg.tweakValue);
    }

    public static TweakRequestDoublePacketServerBound decode(FriendlyByteBuf packetBuffer) {
        return new TweakRequestDoublePacketServerBound((EquipmentSlot)packetBuffer.m_130066_(EquipmentSlot.class), packetBuffer.m_130281_(), packetBuffer.m_130136_(500), packetBuffer.readDouble());
    }

    public static void sendToClient(ServerPlayer entity, EquipmentSlot type, ResourceLocation moduleRegName, String tweakName, double tweakValue) {
        NuminaPackets.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new TweakRequestDoublePacketClientBound(type, moduleRegName, tweakName, tweakValue));
    }

    public static class Handler {
        public static void handle(TweakRequestDoublePacketServerBound message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                ResourceLocation moduleRegName = message.moduleRegName;
                String tweakName = message.tweakName;
                double tweakValue = message.tweakValue;
                if (moduleRegName != null && tweakName != null) {
                    EquipmentSlot type = message.type;
                    ItemUtils.getItemFromEntitySlot((LivingEntity)player, type).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> iItemHandler.setModuleTweakDouble(moduleRegName, tweakName, tweakValue));
                    TweakRequestDoublePacketServerBound.sendToClient(player, type, moduleRegName, tweakName, tweakValue);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

