/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.client;

import com.oblivioussp.spartanshields.client.model.DarkSteelTowerShieldModel;
import com.oblivioussp.spartanshields.client.model.ElementiumTowerShieldModel;
import com.oblivioussp.spartanshields.client.model.EnderiumShieldModel;
import com.oblivioussp.spartanshields.client.model.KiteShieldModel;
import com.oblivioussp.spartanshields.client.model.LumiumShieldModel;
import com.oblivioussp.spartanshields.client.model.ManasteelTowerShieldModel;
import com.oblivioussp.spartanshields.client.model.MekanismTowerShieldModel;
import com.oblivioussp.spartanshields.client.model.ShieldBaseModel;
import com.oblivioussp.spartanshields.client.model.TerrasteelTowerShieldModel;
import com.oblivioussp.spartanshields.client.model.TowerShieldModel;
import com.oblivioussp.spartanshields.client.render.item.ModelLayers;
import com.oblivioussp.spartanshields.client.render.item.TowerShieldBEWLR;
import com.oblivioussp.spartanshields.init.ModItems;
import com.oblivioussp.spartanshields.item.FEPoweredShieldItem;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHelper {
    public static void registerShieldPropertyOverrides(ShieldBaseItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("blocking"), (stack, world, living, value) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public static void registerPoweredShieldPropertyOverrides(FEPoweredShieldItem item) {
        ClientHelper.registerShieldPropertyOverrides(item);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("disabled"), (stack, world, living, value) -> {
            boolean disabled = stack.m_41784_().m_128451_("Energy") <= 0;
            return disabled ? 1.0f : 0.0f;
        });
    }

    @SubscribeEvent
    public static void registerItemColours(RegisterColorHandlersEvent.Item ev) {
        ev.register(new ItemColor(){

            public int m_92671_(ItemStack stack, int layer) {
                return layer == 1 ? 7925891 : 0xFFFFFF;
            }
        }, new ItemLike[]{(ItemLike)ModItems.BASIC_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int m_92671_(ItemStack stack, int layer) {
                return layer == 1 ? 15759491 : 0xFFFFFF;
            }
        }, new ItemLike[]{(ItemLike)ModItems.ADVANCED_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int m_92671_(ItemStack stack, int layer) {
                return layer == 1 ? 7898096 : 0xFFFFFF;
            }
        }, new ItemLike[]{(ItemLike)ModItems.ELITE_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int m_92671_(ItemStack stack, int layer) {
                return layer == 1 ? 15762416 : 0xFFFFFF;
            }
        }, new ItemLike[]{(ItemLike)ModItems.ULTIMATE_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int m_92671_(ItemStack stack, int layer) {
                return layer == 1 ? 8454048 : 0xFFFFFF;
            }
        }, new ItemLike[]{(ItemLike)ModItems.DARK_STEEL_RIOT_BASIC_SHIELD.get()});
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions ev) {
        Log.info("Registering Model Layers!");
        ev.registerLayerDefinition(ModelLayers.BASE_SHIELD, ShieldBaseModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.KITE_SHIELD, KiteShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.TOWER_SHIELD, TowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.LUMIUM_SHIELD, LumiumShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.ENDERIUM_SHIELD, EnderiumShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.MANASTEEL_SHIELD, ManasteelTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.TERRASTEEL_SHIELD, TerrasteelTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.ELEMENTIUM_SHIELD, ElementiumTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.MEKANISM_SHIELD, MekanismTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.DARK_STEEL_SHIELD, DarkSteelTowerShieldModel::createLayer);
        Log.info("Model Layer registration complete!");
    }

    @SubscribeEvent
    public static void reloadClient(RegisterClientReloadListenersEvent ev) {
        ev.registerReloadListener((PreparableReloadListener)TowerShieldBEWLR.INSTANCE);
    }
}

