/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.item.BasicShieldItem;
import com.oblivioussp.spartanshields.item.IDamageShield;
import com.oblivioussp.spartanshields.util.TierSS;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BlockEffectShieldItem
extends BasicShieldItem
implements IDamageShield {
    private final MobEffect effect;
    private final int effectTicks;
    private final int effectLevel;

    public BlockEffectShieldItem(TierSS toolMaterial, int defaultMaxDamage, boolean isTowerShieldIn, MobEffect effectIn, int effectTicksIn, int effectLevelIn, Item.Properties prop) {
        super(toolMaterial, defaultMaxDamage, isTowerShieldIn, prop);
        this.effect = effectIn;
        this.effectTicks = effectTicksIn;
        this.effectLevel = effectLevelIn;
    }

    public BlockEffectShieldItem(TierSS toolMaterial, int defaultMaxDamage, MobEffect effectIn, int effectTicksIn, int effectLevelIn, Item.Properties prop) {
        this(toolMaterial, defaultMaxDamage, false, effectIn, effectTicksIn, effectLevelIn, prop);
    }

    @Override
    public void damageShield(ItemStack shieldStack, Player player, Entity attacker, float damage) {
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            attackerLiving.m_7292_(new MobEffectInstance(this.effect, this.effectTicks, this.effectLevel, false, true));
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        MutableComponent effectName = Component.m_237115_((String)this.effect.m_19481_());
        if (this.effectLevel > 0) {
            effectName = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectName, Component.m_237115_((String)("potion.potency." + this.effectLevel))});
        }
        tooltip.add((Component)Component.m_237110_((String)"tooltip.spartanshields.on_block", (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanshields.inflict_mob_effect.desc", (Object[])new Object[]{effectName.m_130940_(ChatFormatting.AQUA), Float.valueOf((float)this.effectTicks / 20.0f)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GOLD));
    }
}

