/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data.model;

import com.oblivioussp.spartanweaponry.api.ModelOverrides;
import com.oblivioussp.spartanweaponry.api.data.OilCoatingTextures;
import com.oblivioussp.spartanweaponry.api.data.model.BaseModels;
import com.oblivioussp.spartanweaponry.api.data.model.OilCoatingItemModelBuilder;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public class ModelGenerator {
    protected final ItemModelProvider itemModelProvider;

    public ModelGenerator(ItemModelProvider itemModelProviderIn) {
        this.itemModelProvider = itemModelProviderIn;
    }

    public ResourceLocation createSimpleModel(Item item) {
        return this.createSimpleModel(item, null, "");
    }

    public ResourceLocation createSimpleModel(Item item, String textureFolderPath) {
        return this.createSimpleModel(item, null, textureFolderPath);
    }

    public ResourceLocation createSimpleModel(Item item, ResourceLocation parent) {
        return this.createSimpleModel(item, parent, "");
    }

    public ResourceLocation createSimpleModel(Item item, @Nullable ResourceLocation parent, String textureFolderPath) {
        ResourceLocation parentPath = parent != null ? parent : this.itemModelProvider.mcLoc("item/generated");
        Object texturePath = textureFolderPath.isEmpty() ? "item/" : "item/" + textureFolderPath + "/";
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, parentPath)).texture("layer0", (String)texturePath + itemPath)).getLocation();
    }

    public ResourceLocation createMeleeWeaponModels(Item item, ResourceLocation baseModel, ResourceLocation coatingTexture) {
        return this.createMeleeWeaponModels(item, baseModel, coatingTexture, "");
    }

    public ResourceLocation createMeleeWeaponModels(Item item, ResourceLocation baseModel, ResourceLocation coatingTexture, String textureFolderPath) {
        Object texturePath = textureFolderPath.isEmpty() ? "item/" : "item/" + textureFolderPath + "/";
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ResourceLocation blockingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_blocking", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_blocking"))).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", (String)texturePath + itemPath)).texture("coating", coatingTexture)).getLocation();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_throwing"))).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", (String)texturePath + itemPath)).texture("coating", coatingTexture)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, baseModel)).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", (String)texturePath + itemPath)).texture("coating", coatingTexture)).override().predicate(ModelOverrides.BLOCKING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(blockingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.THROWING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createCestusModels(Item item, ResourceLocation baseModel, ResourceLocation coatingTexture) {
        return this.createCestusModels(item, baseModel, coatingTexture, "");
    }

    public ResourceLocation createCestusModels(Item item, ResourceLocation baseModel, ResourceLocation coatingTexture, String textureFolderPath) {
        Object texturePath = textureFolderPath.isEmpty() ? "item/" : "item/" + textureFolderPath + "/";
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ResourceLocation blockingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_blocking", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_blocking"))).texture("layer0", (String)texturePath + itemPath)).getLocation();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_throwing"))).texture("layer0", (String)texturePath + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, baseModel)).texture("layer0", (String)texturePath + itemPath)).override().predicate(ModelOverrides.BLOCKING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(blockingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.THROWING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createThrowingWeaponModels(Item item, ResourceLocation baseModel, ResourceLocation baseThrowingModel, ResourceLocation emptyModel) {
        return this.createThrowingWeaponModels(item, baseModel, baseThrowingModel, emptyModel, "");
    }

    public ResourceLocation createThrowingWeaponModels(Item item, ResourceLocation baseModel, ResourceLocation baseThrowingModel, ResourceLocation emptyModel, String textureFolderPath) {
        Object texturePath = textureFolderPath.isEmpty() ? "item/" : "item/" + textureFolderPath + "/";
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", baseThrowingModel)).texture("layer0", (String)texturePath + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, baseModel)).texture("layer0", (String)texturePath + itemPath)).override().predicate(ModelOverrides.THROWING, 1.0f).predicate(ModelOverrides.EMPTY, 0.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.EMPTY, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(emptyModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createVanillaSwordModels(Item item) {
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, "minecraft:item/handheld")).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", "minecraft:item/" + itemPath)).texture("coating", OilCoatingTextures.VANILLA_SWORD)).getLocation();
    }

    public ResourceLocation createDaggerModels(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.DAGGER, OilCoatingTextures.DAGGER);
    }

    public ResourceLocation createDaggerModels(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.DAGGER, OilCoatingTextures.DAGGER, textureFolderPath);
    }

    public ResourceLocation createParryingDaggerModels(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.PARRYING_DAGGER, OilCoatingTextures.PARRYING_DAGGER);
    }

    public ResourceLocation createParryingDaggerModels(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.PARRYING_DAGGER, OilCoatingTextures.PARRYING_DAGGER, textureFolderPath);
    }

    public ResourceLocation createLongswordModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.LONGSWORD, OilCoatingTextures.LONGSWORD);
    }

    public ResourceLocation createLongswordModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.LONGSWORD, OilCoatingTextures.LONGSWORD, textureFolderPath);
    }

    public ResourceLocation createKatanaModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.KATANA, OilCoatingTextures.KATANA);
    }

    public ResourceLocation createKatanaModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.KATANA, OilCoatingTextures.KATANA, textureFolderPath);
    }

    public ResourceLocation createSaberModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.SABER, OilCoatingTextures.SABER);
    }

    public ResourceLocation createSaberModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.SABER, OilCoatingTextures.SABER, textureFolderPath);
    }

    public ResourceLocation createRapierModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.RAPIER, OilCoatingTextures.RAPIER);
    }

    public ResourceLocation createRapierModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.RAPIER, OilCoatingTextures.RAPIER, textureFolderPath);
    }

    public ResourceLocation createGreatswordModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.GREATSWORD, OilCoatingTextures.GREATSWORD);
    }

    public ResourceLocation createGreatswordModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.GREATSWORD, OilCoatingTextures.GREATSWORD, textureFolderPath);
    }

    public ResourceLocation createClubModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.CLUB, OilCoatingTextures.CLUB);
    }

    public ResourceLocation createClubModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.CLUB, OilCoatingTextures.CLUB, textureFolderPath);
    }

    public ResourceLocation createCestusModel(Item item) {
        return this.createCestusModels(item, BaseModels.CESTUS, OilCoatingTextures.CESTUS);
    }

    public ResourceLocation createCestusModel(Item item, String textureFolderPath) {
        return this.createCestusModels(item, BaseModels.CESTUS, OilCoatingTextures.CESTUS, textureFolderPath);
    }

    public ResourceLocation createBattleHammerModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.BATTLE_HAMMER, OilCoatingTextures.BATTLE_HAMMER);
    }

    public ResourceLocation createBattleHammerModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.BATTLE_HAMMER, OilCoatingTextures.BATTLE_HAMMER, textureFolderPath);
    }

    public ResourceLocation createWarhammerModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.WARHAMMER, OilCoatingTextures.WARHAMMER);
    }

    public ResourceLocation createWarhammerModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.WARHAMMER, OilCoatingTextures.WARHAMMER, textureFolderPath);
    }

    public ResourceLocation createSpearModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.SPEAR, OilCoatingTextures.SPEAR);
    }

    public ResourceLocation createSpearModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.SPEAR, OilCoatingTextures.SPEAR, textureFolderPath);
    }

    public ResourceLocation createHalberdModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.HALBERD, OilCoatingTextures.HALBERD);
    }

    public ResourceLocation createHalberdModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.HALBERD, OilCoatingTextures.HALBERD, textureFolderPath);
    }

    public ResourceLocation createPikeModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.PIKE, OilCoatingTextures.PIKE);
    }

    public ResourceLocation createPikeModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.PIKE, OilCoatingTextures.PIKE, textureFolderPath);
    }

    public ResourceLocation createLanceModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.LANCE, OilCoatingTextures.LANCE);
    }

    public ResourceLocation createLanceModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.LANCE, OilCoatingTextures.LANCE, textureFolderPath);
    }

    public ResourceLocation createLongbowModels(Item item) {
        return this.createLongbowModels(item, "");
    }

    public ResourceLocation createLongbowModels(Item item, String textureFolderPath) {
        Object texturePath = textureFolderPath.isEmpty() ? "item/" : "item/" + textureFolderPath + "/";
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ResourceLocation pulling0 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_0", BaseModels.LONGBOW_PULLING)).texture("layer0", (String)texturePath + itemPath + "_pulling_0")).getLocation();
        ResourceLocation pulling1 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_1", BaseModels.LONGBOW_PULLING)).texture("layer0", (String)texturePath + itemPath + "_pulling_1")).getLocation();
        ResourceLocation pulling2 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_2", BaseModels.LONGBOW_PULLING)).texture("layer0", (String)texturePath + itemPath + "_pulling_2")).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.LONGBOW)).texture("layer0", (String)texturePath + itemPath + "_standby")).override().predicate(ModelOverrides.PULLING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling0, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 0.65f).model((ModelFile)new ModelFile.ExistingModelFile(pulling1, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 0.9f).model((ModelFile)new ModelFile.ExistingModelFile(pulling2, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createHeavyCrossbowModels(Item item) {
        return this.createHeavyCrossbowModels(item, "");
    }

    public ResourceLocation createHeavyCrossbowModels(Item item, String textureFolderPath) {
        Object texturePath = textureFolderPath.isEmpty() ? "item/" : "item/" + textureFolderPath + "/";
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ResourceLocation pulling0 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_0", BaseModels.HEAVY_CROSSBOW_PULLING)).texture("layer0", (String)texturePath + itemPath + "_pulling_0")).getLocation();
        ResourceLocation pulling1 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_1", BaseModels.HEAVY_CROSSBOW_PULLING)).texture("layer0", (String)texturePath + itemPath + "_pulling_1")).getLocation();
        ResourceLocation pulling2 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_2", BaseModels.HEAVY_CROSSBOW_PULLING)).texture("layer0", (String)texturePath + itemPath + "_pulling_2")).getLocation();
        ResourceLocation loaded = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_loaded", BaseModels.HEAVY_CROSSBOW_LOADED)).texture("layer0", (String)texturePath + itemPath + "_loaded")).getLocation();
        ResourceLocation firing = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_firing", BaseModels.HEAVY_CROSSBOW_FIRING)).texture("layer0", (String)texturePath + itemPath + "_loaded")).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.HEAVY_CROSSBOW)).texture("layer0", (String)texturePath + itemPath + "_standby")).override().predicate(ModelOverrides.PULLING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling0, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 0.65f).model((ModelFile)new ModelFile.ExistingModelFile(pulling1, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling2, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.CHARGED, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(loaded, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.CHARGED, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(firing, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createThrowingKnifeModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.THROWING_KNIFE, BaseModels.THROWING_KNIFE_THROWING, BaseModels.THROWING_KNIFE_EMPTY);
    }

    public ResourceLocation createThrowingKnifeModels(Item item, String textureFolderPath) {
        return this.createThrowingWeaponModels(item, BaseModels.THROWING_KNIFE, BaseModels.THROWING_KNIFE_THROWING, BaseModels.THROWING_KNIFE_EMPTY, textureFolderPath);
    }

    public ResourceLocation createTomahawkModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.TOMAHAWK, BaseModels.TOMAHAWK_THROWING, BaseModels.TOMAHAWK_EMPTY);
    }

    public ResourceLocation createTomahawkModels(Item item, String textureFolderPath) {
        return this.createThrowingWeaponModels(item, BaseModels.TOMAHAWK, BaseModels.TOMAHAWK_THROWING, BaseModels.TOMAHAWK_EMPTY, textureFolderPath);
    }

    public ResourceLocation createJavelinModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.JAVELIN, BaseModels.JAVELIN_THROWING, BaseModels.JAVELIN_EMPTY);
    }

    public ResourceLocation createJavelinModels(Item item, String textureFolderPath) {
        return this.createThrowingWeaponModels(item, BaseModels.JAVELIN, BaseModels.JAVELIN_THROWING, BaseModels.JAVELIN_EMPTY, textureFolderPath);
    }

    public ResourceLocation createBoomerangModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.BOOMERANG, BaseModels.BOOMERANG_THROWING, BaseModels.BOOMERANG_EMPTY);
    }

    public ResourceLocation createBoomerangModels(Item item, String textureFolderPath) {
        return this.createThrowingWeaponModels(item, BaseModels.BOOMERANG, BaseModels.BOOMERANG_THROWING, BaseModels.BOOMERANG_EMPTY, textureFolderPath);
    }

    public ResourceLocation createBattleaxeModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.BATTLEAXE, OilCoatingTextures.BATTLEAXE);
    }

    public ResourceLocation createBattleaxeModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.BATTLEAXE, OilCoatingTextures.BATTLEAXE, textureFolderPath);
    }

    public ResourceLocation createFlangedMaceModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.FLANGED_MACE, OilCoatingTextures.FLANGED_MACE);
    }

    public ResourceLocation createFlangedMaceModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.FLANGED_MACE, OilCoatingTextures.FLANGED_MACE, textureFolderPath);
    }

    public ResourceLocation createGlaiveModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.GLAIVE, OilCoatingTextures.GLAIVE);
    }

    public ResourceLocation createGlaiveModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.GLAIVE, OilCoatingTextures.GLAIVE, textureFolderPath);
    }

    public ResourceLocation createQuarterstaffModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.QUARTERSTAFF, OilCoatingTextures.QUARTERSTAFF);
    }

    public ResourceLocation createQuarterstaffModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.QUARTERSTAFF, OilCoatingTextures.QUARTERSTAFF, textureFolderPath);
    }

    public ResourceLocation createScytheModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.SCYTHE, OilCoatingTextures.SCYTHE);
    }

    public ResourceLocation createScytheModel(Item item, String textureFolderPath) {
        return this.createMeleeWeaponModels(item, BaseModels.SCYTHE, OilCoatingTextures.SCYTHE, textureFolderPath);
    }
}

