/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.data;

import com.oblivioussp.spartanweaponry.api.ModelOverrides;
import com.oblivioussp.spartanweaponry.api.data.model.BaseModels;
import com.oblivioussp.spartanweaponry.api.data.model.ModelGenerator;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.ArrayList;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "spartanweaponry", existingFileHelper);
    }

    protected void registerModels() {
        ModelGenerator generator = new ModelGenerator(this);
        generator.createSimpleModel((Item)ModItems.SIMPLE_HANDLE.get());
        generator.createSimpleModel((Item)ModItems.HANDLE.get());
        generator.createSimpleModel((Item)ModItems.SIMPLE_POLE.get(), BaseModels.POLE);
        generator.createSimpleModel((Item)ModItems.POLE.get(), BaseModels.POLE);
        generator.createSimpleModel((Item)ModItems.EXPLOSIVE_CHARGE.get());
        generator.createSimpleModel((Item)ModItems.GREASE_BALL.get());
        for (Item dagger : ModItems.DAGGERS.getAsList()) {
            generator.createDaggerModels(dagger);
        }
        for (Item parryingDagger : ModItems.PARRYING_DAGGERS.getAsList()) {
            generator.createParryingDaggerModels(parryingDagger);
        }
        for (Item longsword : ModItems.LONGSWORDS.getAsList()) {
            generator.createLongswordModel(longsword);
        }
        for (Item katana : ModItems.KATANAS.getAsList()) {
            generator.createKatanaModel(katana);
        }
        for (Item saber : ModItems.SABERS.getAsList()) {
            generator.createSaberModel(saber);
        }
        for (Item rapiers : ModItems.RAPIERS.getAsList()) {
            generator.createRapierModel(rapiers);
        }
        for (Item greatsword : ModItems.GREATSWORDS.getAsList()) {
            generator.createGreatswordModel(greatsword);
        }
        generator.createClubModel((Item)ModItems.WOODEN_CLUB.get());
        generator.createClubModel((Item)ModItems.STUDDED_CLUB.get());
        generator.createCestusModel((Item)ModItems.CESTUS.get());
        generator.createCestusModel((Item)ModItems.STUDDED_CESTUS.get());
        for (Item battleHammer : ModItems.BATTLE_HAMMERS.getAsList()) {
            generator.createBattleHammerModel(battleHammer);
        }
        for (Item warhammer : ModItems.WARHAMMERS.getAsList()) {
            generator.createWarhammerModel(warhammer);
        }
        for (Item spear : ModItems.SPEARS.getAsList()) {
            generator.createSpearModel(spear);
        }
        for (Item halberd : ModItems.HALBERDS.getAsList()) {
            generator.createHalberdModel(halberd);
        }
        for (Item pike : ModItems.PIKES.getAsList()) {
            generator.createPikeModel(pike);
        }
        for (Item lance : ModItems.LANCES.getAsList()) {
            generator.createLanceModel(lance);
        }
        for (Item longbow : ModItems.LONGBOWS.getAsList()) {
            generator.createLongbowModels(longbow);
        }
        for (Item heavyCrossbow : ModItems.HEAVY_CROSSBOWS.getAsList()) {
            generator.createHeavyCrossbowModels(heavyCrossbow);
        }
        for (Item throwingKnife : ModItems.THROWING_KNIVES.getAsList()) {
            generator.createThrowingKnifeModels(throwingKnife);
        }
        for (Item tomahawk : ModItems.TOMAHAWKS.getAsList()) {
            generator.createTomahawkModels(tomahawk);
        }
        for (Item javelin : ModItems.JAVELINS.getAsList()) {
            generator.createJavelinModels(javelin);
        }
        for (Item boomerang : ModItems.BOOMERANGS.getAsList()) {
            generator.createBoomerangModels(boomerang);
        }
        for (Item battleaxe : ModItems.BATTLEAXES.getAsList()) {
            generator.createBattleaxeModel(battleaxe);
        }
        for (Item flangedMace : ModItems.FLANGED_MACES.getAsList()) {
            generator.createFlangedMaceModel(flangedMace);
        }
        for (Item glaive : ModItems.GLAIVES.getAsList()) {
            generator.createGlaiveModel(glaive);
        }
        for (Item quarterstaff : ModItems.QUARTERSTAVES.getAsList()) {
            generator.createQuarterstaffModel(quarterstaff);
        }
        for (Item scythe : ModItems.SCYTHES.getAsList()) {
            generator.createScytheModel(scythe);
        }
        generator.createSimpleModel((Item)ModItems.WOODEN_ARROW.get());
        this.createTippedArrowModel((Item)ModItems.TIPPED_WOODEN_ARROW.get());
        generator.createSimpleModel((Item)ModItems.COPPER_ARROW.get());
        this.createTippedArrowModel((Item)ModItems.TIPPED_COPPER_ARROW.get());
        generator.createSimpleModel((Item)ModItems.IRON_ARROW.get());
        this.createTippedArrowModel((Item)ModItems.TIPPED_IRON_ARROW.get());
        generator.createSimpleModel((Item)ModItems.DIAMOND_ARROW.get());
        this.createTippedArrowModel((Item)ModItems.TIPPED_DIAMOND_ARROW.get());
        generator.createSimpleModel((Item)ModItems.NETHERITE_ARROW.get());
        this.createTippedArrowModel((Item)ModItems.TIPPED_NETHERITE_ARROW.get());
        generator.createSimpleModel((Item)ModItems.EXPLOSIVE_ARROW.get());
        generator.createSimpleModel((Item)ModItems.BOLT.get());
        this.createTippedBoltModel((Item)ModItems.TIPPED_BOLT.get());
        generator.createSimpleModel((Item)ModItems.SPECTRAL_BOLT.get());
        generator.createSimpleModel((Item)ModItems.COPPER_BOLT.get());
        this.createTippedBoltModel((Item)ModItems.TIPPED_COPPER_BOLT.get());
        generator.createSimpleModel((Item)ModItems.DIAMOND_BOLT.get());
        this.createTippedBoltModel((Item)ModItems.TIPPED_DIAMOND_BOLT.get());
        generator.createSimpleModel((Item)ModItems.NETHERITE_BOLT.get());
        this.createTippedBoltModel((Item)ModItems.TIPPED_NETHERITE_BOLT.get());
        this.createQuiverModels((Item)ModItems.SMALL_ARROW_QUIVER.get(), 3);
        this.createQuiverModels((Item)ModItems.MEDIUM_ARROW_QUIVER.get(), 3);
        this.createQuiverModels((Item)ModItems.LARGE_ARROW_QUIVER.get(), 5);
        this.createQuiverModels((Item)ModItems.HUGE_ARROW_QUIVER.get(), 5);
        this.createQuiverModels((Item)ModItems.SMALL_BOLT_QUIVER.get(), 3);
        this.createQuiverModels((Item)ModItems.MEDIUM_BOLT_QUIVER.get(), 3);
        this.createQuiverModels((Item)ModItems.LARGE_BOLT_QUIVER.get(), 5);
        this.createQuiverModels((Item)ModItems.HUGE_BOLT_QUIVER.get(), 5);
        generator.createSimpleModel((Item)ModItems.QUIVER_COMPARTMENT.get());
        generator.createSimpleModel((Item)ModItems.MEDIUM_QUIVER_BRACE.get());
        generator.createSimpleModel((Item)ModItems.LARGE_QUIVER_BRACE.get());
        generator.createSimpleModel((Item)ModItems.HUGE_QUIVER_BRACE.get());
        generator.createSimpleModel((Item)ModItems.DYNAMITE.get());
        this.createWeaponOilModel((Item)ModItems.WEAPON_OIL.get());
    }

    protected ResourceLocation createTippedArrowModel(Item item) {
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_base")).texture("layer1", "item/tipped_arrow_head")).getLocation();
    }

    protected ResourceLocation createTippedBoltModel(Item item) {
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_base")).texture("layer1", "item/tipped_bolt_head")).getLocation();
    }

    protected ResourceLocation createQuiverModels(Item item, int variantCount) {
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (int i = 0; i < variantCount; ++i) {
            String modelVariant = itemPath + "_" + Integer.toString(i + 1);
            variants.add(((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(modelVariant, this.mcLoc("item/generated"))).texture("layer0", "item/" + modelVariant)).getLocation());
        }
        ItemModelBuilder modelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_base");
        for (int j = 0; j < variants.size(); ++j) {
            modelBuilder.override().predicate(ModelOverrides.ARROW, (float)(j + 1)).model((ModelFile)new ModelFile.ExistingModelFile((ResourceLocation)variants.get(j), this.existingFileHelper)).end();
        }
        return modelBuilder.getLocation();
    }

    protected ResourceLocation createWeaponOilModel(Item item) {
        String itemPath = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemPath, this.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath + "_bottle")).texture("layer1", "item/" + itemPath + "_bottle_overlay")).getLocation();
    }

    public String m_6055_() {
        return "Spartan Weaponry Item Models";
    }
}

