/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.api.trait.IGenericTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IRangedTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.client.gui.HudCrosshairHeavyCrossbow;
import com.oblivioussp.spartanweaponry.client.gui.ICrosshairOverlay;
import com.oblivioussp.spartanweaponry.entity.projectile.BoltEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.BoltItem;
import com.oblivioussp.spartanweaponry.item.IHudCrosshair;
import com.oblivioussp.spartanweaponry.item.IHudLoadState;
import com.oblivioussp.spartanweaponry.util.ClientConfig;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class HeavyCrossbowItem
extends CrossbowItem
implements IReloadable,
IHudLoadState,
IHudCrosshair {
    protected WeaponMaterial material;
    protected String modId = null;
    protected int loadTicks;
    protected int aimTicks;
    protected String customDisplayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected final WeaponType type = WeaponType.RANGED;
    protected List<WeaponTrait> rangedTraits;
    protected Multimap<Attribute, AttributeModifier> modifiers;
    public static final String NBT_CHARGED = "Charged";
    public static final String NBT_PROJECTILE = "Projectile";
    public static final Predicate<ItemStack> BOLT = stack -> stack.m_204117_(ModItemTags.BOLTS);

    public HeavyCrossbowItem(Item.Properties prop, WeaponMaterial material) {
        super(prop.m_41503_((int)((float)material.m_6609_() * 1.5f)));
        this.material = material;
        this.loadTicks = 25;
        this.aimTicks = 10;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerHeavyCrossbowPropertyOverrides(this);
        }
        ReloadableHandler.addToItemReloadList(this);
    }

    public HeavyCrossbowItem(Item.Properties prop, WeaponMaterial material, String customDisplayName) {
        this(prop, material);
        if (material.useCustomDisplayName()) {
            this.customDisplayName = customDisplayName;
        }
    }

    @Override
    public void reload() {
        this.loadTicks = 25;
        this.aimTicks = 10;
        this.rangedTraits = this.material.getBonusTraits(this.type);
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (WeaponTrait trait : this.rangedTraits) {
            Optional<IRangedTraitCallback> opt = trait.getRangedCallback();
            if (opt.isPresent()) {
                IRangedTraitCallback callback2 = opt.get();
                this.loadTicks = callback2.modifyHeavyCrossbowLoadTime(this.material, this.loadTicks);
                this.aimTicks = callback2.modifyHeavyCrossbowAimTime(this.material, this.aimTicks);
            }
            Optional<IGenericTraitCallback> generic = trait.getGenericCallback();
            generic.ifPresent(callback -> callback.onModifyAttributes((ImmutableMultimap.Builder<Attribute, AttributeModifier>)mapBuilder));
        }
        this.modifiers = mapBuilder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return this.modifiers != null && equipmentSlot == EquipmentSlot.MAINHAND ? this.modifiers : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.m_6609_();
    }

    public Predicate<ItemStack> m_6437_() {
        return BOLT;
    }

    public Predicate<ItemStack> m_6442_() {
        return BOLT;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level levelIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            boolean isCreativeOrInfinite;
            Player player = (Player)entityLiving;
            boolean bl = isCreativeOrInfinite = player.m_150110_().f_35937_ || stack.getEnchantmentLevel(Enchantments.f_44952_) > 0;
            if (this.getLoadProgress(stack, entityLiving) == 1.0f) {
                stack.m_41784_().m_128379_(NBT_CHARGED, true);
                ItemStack bolt = ItemStack.f_41583_;
                int count = stack.getEnchantmentLevel(Enchantments.f_44959_) > 0 ? 3 : 1;
                bolt = entityLiving.m_6298_(stack);
                if (bolt.m_41619_() || !BOLT.test(bolt)) {
                    bolt = new ItemStack((ItemLike)ModItems.BOLT.get(), count);
                }
                ItemStack boltToStore = bolt.m_41777_();
                boltToStore.m_41764_(count);
                CompoundTag nbtBolt = new CompoundTag();
                boltToStore.m_41739_(nbtBolt);
                stack.m_41783_().m_128365_(NBT_PROJECTILE, (Tag)nbtBolt);
                if (!player.m_150110_().f_35937_) {
                    bolt.m_41774_(1);
                    if (bolt.m_41619_()) {
                        player.m_150109_().m_36057_(bolt);
                    }
                }
                levelIn.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11841_, SoundSource.PLAYERS, 1.0f, 1.0f / (levelIn.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
            } else {
                int i;
                ItemStack itemstack = ItemStack.f_41583_;
                CompoundTag tag = stack.m_41784_().m_128469_(NBT_PROJECTILE);
                if (tag != null && !tag.m_128456_()) {
                    itemstack = ItemStack.m_41712_((CompoundTag)tag);
                }
                if ((i = this.m_8105_(stack) - timeLeft) < 0 || !stack.m_41783_().m_128471_(NBT_CHARGED)) {
                    return;
                }
                if (!itemstack.m_41619_() || isCreativeOrInfinite) {
                    if (itemstack.m_41619_()) {
                        itemstack = new ItemStack((ItemLike)ModItems.BOLT.get());
                    }
                    if (!levelIn.f_46443_) {
                        BoltItem itemBolt = (BoltItem)(itemstack.m_41720_() instanceof BoltItem ? itemstack.m_41720_() : ModItems.BOLT);
                        boolean flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof BoltItem && ((BoltItem)itemstack.m_41720_()).isInfinite(itemstack, stack, player);
                        int stackAimTicks = this.getAimTicks(stack);
                        int inaccuracy = Mth.m_14045_((int)(stackAimTicks - i), (int)0, (int)stackAimTicks);
                        float inaccuracyModifier = 0.0f;
                        if (inaccuracy != 0) {
                            inaccuracyModifier = 12.0f * ((float)inaccuracy / (float)stackAimTicks);
                        }
                        this.spawnProjectile(stack, itemBolt, itemstack, levelIn, player, flag1, inaccuracyModifier, 0.0f);
                        if (itemstack.m_41613_() > 1) {
                            this.spawnProjectile(stack, itemBolt, itemstack, levelIn, player, flag1, inaccuracyModifier, -10.0f);
                            this.spawnProjectile(stack, itemBolt, itemstack, levelIn, player, flag1, inaccuracyModifier, 10.0f);
                        }
                        int damage = itemstack.m_41613_() > 1 ? 3 : 1;
                        stack.m_41622_(damage, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(player.m_7655_()));
                        stack.m_41783_().m_128379_(NBT_CHARGED, false);
                        stack.m_41783_().m_128365_(NBT_PROJECTILE, (Tag)new CompoundTag());
                    }
                    levelIn.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.NEUTRAL, 1.0f, 1.0f / (levelIn.f_46441_.m_188501_() * 0.4f + 1.2f) + 0.75f);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public static float getBoltVelocity(BoltEntity bolt) {
        return 4.5f * bolt.getRangeMultiplier();
    }

    protected void spawnProjectile(ItemStack crossbow, BoltItem boltItem, ItemStack boltStack, Level levelIn, Player player, boolean creativeOrInfinite, float inaccuracyModifier, float projectileAngle) {
        int k;
        BoltEntity bolt = boltItem.createBolt(levelIn, boltStack, (LivingEntity)player);
        bolt.m_36762_(true);
        bolt.m_36740_(SoundEvents.f_11840_);
        bolt.m_36793_(true);
        int pierceLvl = crossbow.getEnchantmentLevel(Enchantments.f_44961_);
        if (pierceLvl > 0) {
            bolt.m_36767_((byte)pierceLvl);
        }
        Vec3 upVector = player.m_20289_(1.0f);
        Quaternionf quat = new Quaternionf().setAngleAxis((double)(projectileAngle * ((float)Math.PI / 180)), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
        Vector3f velocityVec = player.m_20252_(1.0f).m_252839_().rotate((Quaternionfc)quat);
        bolt.m_6686_(velocityVec.x, velocityVec.y, velocityVec.z, HeavyCrossbowItem.getBoltVelocity(bolt), inaccuracyModifier);
        for (WeaponTrait trait : this.rangedTraits) {
            trait.getRangedCallback().ifPresent(callback -> callback.onProjectileSpawn(this.material, bolt));
        }
        int j = crossbow.getEnchantmentLevel(Enchantments.f_44988_);
        if (j > 0) {
            bolt.m_36781_(bolt.m_36789_() + (double)j * 0.5 + 0.5);
        }
        if ((k = crossbow.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
            bolt.m_36735_(k);
        }
        if (crossbow.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
            bolt.m_20254_(100);
        }
        if (creativeOrInfinite || projectileAngle != 0.0f) {
            bolt.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        levelIn.m_7967_((Entity)bolt);
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (!stack.m_41784_().m_128471_(NBT_CHARGED)) {
            return UseAnim.CROSSBOW;
        }
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        boolean hasAmmo;
        ItemStack stack = playerIn.m_21120_(handIn);
        ItemStack ammoStack = playerIn.m_6298_(stack);
        boolean bl = hasAmmo = !ammoStack.m_41619_();
        if (!(playerIn.m_150110_().f_35937_ || hasAmmo || stack.m_41784_().m_128471_(NBT_CHARGED) || stack.getEnchantmentLevel(Enchantments.f_44952_) != 0)) {
            return !hasAmmo ? InteractionResultHolder.m_19100_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level levelIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (!levelIn.f_46443_ && !stack.m_41784_().m_128471_(NBT_CHARGED) && livingEntityIn instanceof Player) {
            float loadTicks = this.getLoadProgress(stack, livingEntityIn);
            SoundEvent loadingSound = null;
            if (loadTicks == 0.0f) {
                loadingSound = SoundEvents.f_11843_;
            } else if (loadTicks == 0.5f || loadTicks == 0.9f) {
                loadingSound = SoundEvents.f_11842_;
            }
            if (loadingSound != null) {
                levelIn.m_6263_((Player)null, livingEntityIn.m_20185_(), livingEntityIn.m_20186_(), livingEntityIn.m_20189_(), loadingSound, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.material != null ? this.material.m_6601_() : 1;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.material.m_6282_().test(repair);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int damage = amount;
        for (WeaponTrait trait : this.rangedTraits) {
            if (trait.getGenericCallback().isPresent()) {
                damage = trait.getGenericCallback().get().onDamageItem(stack, entity, damage);
            }
            if (damage > 0) continue;
            break;
        }
        return Math.max(0, damage);
    }

    public Component m_7626_(ItemStack stack) {
        if (this.customDisplayName == null) {
            return super.m_7626_(stack);
        }
        return Component.m_237110_((String)this.customDisplayName, (Object[])new Object[]{this.material.translateName()});
    }

    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        ItemStack bolt;
        boolean isShiftPressed = Screen.m_96638_();
        if (this.doCraftCheck && levelIn != null) {
            ITagManager tagManager;
            if (!(((Boolean)ClientConfig.INSTANCE.forceDisableUncraftableTooltips.get()).booleanValue() || this.material.getModId() != "spartanweaponry" || (tagManager = ForgeRegistries.ITEMS.tags()).isKnownTagName(this.material.getRepairTag()) && !tagManager.getTag(this.material.getRepairTag()).isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.uncraftable_missing_material", "spartanweaponry"), (Object[])new Object[]{this.material.getRepairTagName()}).m_130940_(ChatFormatting.RED));
        }
        this.material.addTagErrorTooltip(stack, tooltip);
        if (stack.m_41784_().m_128441_(NBT_CHARGED) && !(bolt = ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_(NBT_PROJECTILE))).m_41619_()) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.heavy_crossbow.loaded_bolt", "spartanweaponry"), (Object[])new Object[]{String.format("[%s x%d]", ChatFormatting.AQUA.toString() + bolt.m_41786_().getString() + ChatFormatting.WHITE.toString(), bolt.m_41613_())}));
            tooltip.add((Component)Component.m_237119_());
        }
        if (this.material.hasAnyBonusTraits(this.type)) {
            if (isShiftPressed) {
                tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.traits", "spartanweaponry"), (Object[])new Object[]{Component.m_237115_((String)"tooltip.spartanweaponry.showing_details").m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.traits", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanweaponry.show_details", (Object[])new Object[]{ChatFormatting.DARK_AQUA.toString() + "SHIFT"}).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            }
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.%s.trait.material_bonus", "spartanweaponry")).m_130940_(ChatFormatting.AQUA));
            this.rangedTraits.forEach(trait -> trait.addTooltip(stack, tooltip, isShiftPressed));
            tooltip.add((Component)Component.m_237119_());
        }
        if (isShiftPressed) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.description", "spartanweaponry"), (Object[])new Object[]{Component.m_237115_((String)"tooltip.spartanweaponry.showing_details").m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.%s.heavy_crossbow.desc", "spartanweaponry")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.%s.heavy_crossbow.desc_2", "spartanweaponry")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.%s.heavy_crossbow.desc_3", "spartanweaponry")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.description", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanweaponry.show_details", (Object[])new Object[]{ChatFormatting.AQUA.toString() + "SHIFT"}).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.modifiers.ammo.type", "spartanweaponry"), (Object[])new Object[]{Component.m_237115_((String)String.format("tooltip.%s.modifiers.ammo.bolt", "spartanweaponry")).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.modifiers.heavy_crossbow.load_time", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)String.format("tooltip.%s.modifiers.heavy_crossbow.load_time.value", "spartanweaponry"), (Object[])new Object[]{Float.valueOf((float)this.getFullLoadTicks(stack) / 20.0f)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.modifiers.heavy_crossbow.aim_time", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)String.format("tooltip.%s.modifiers.heavy_crossbow.aim_time.value", "spartanweaponry"), (Object[])new Object[]{Float.valueOf((float)this.getAimTicks(stack) / 20.0f)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237119_());
    }

    public Component getHighlightTip(ItemStack item, Component displayName) {
        ItemStack bolt;
        if (item.m_41782_() && !(bolt = ItemStack.m_41712_((CompoundTag)item.m_41783_().m_128469_(NBT_PROJECTILE))).m_41619_()) {
            return Component.m_237110_((String)"tooltip.spartanweaponry.highlight_heavy_crossbow", (Object[])new Object[]{displayName, bolt.m_41786_(), bolt.m_41613_()});
        }
        return super.getHighlightTip(item, displayName);
    }

    @Override
    public boolean isLoaded(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_(NBT_CHARGED);
    }

    @Override
    public float getLoadProgress(ItemStack stack, LivingEntity living) {
        return !this.isLoaded(stack) ? Mth.m_14036_((float)((float)this.getLoadingTicks(stack, living) / (float)this.getFullLoadTicks(stack)), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public int getFullLoadTicks(ItemStack stack) {
        int i = stack.getEnchantmentLevel(Enchantments.f_44960_);
        return Mth.m_14045_((int)(this.loadTicks - 5 * i), (int)0, (int)this.loadTicks);
    }

    public int getLoadingTicks(ItemStack stack, LivingEntity living) {
        return living.m_21252_();
    }

    public int getAimTicks(ItemStack stack) {
        int i = stack.getEnchantmentLevel((Enchantment)ModEnchantments.SHARPSHOOTER.get());
        return Mth.m_14045_((int)(this.aimTicks - 2 * i), (int)0, (int)this.aimTicks);
    }

    @Override
    public ICrosshairOverlay getCrosshairHudElement() {
        return HudCrosshairHeavyCrossbow::render;
    }
}

