/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.mojang.datafixers.util.Either;
import com.oblivioussp.spartanweaponry.client.model.OilCoatedItemModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemModelGenerator.class})
public class ItemModelGeneratorMixin {
    @Inject(at={@At(value="HEAD")}, method={"generateBlockModel(Ljava/util/function/Function;Lnet/minecraft/client/renderer/block/model/BlockModel;)Lnet/minecraft/client/renderer/block/model/BlockModel;"}, cancellable=true)
    public void generateBlockModel(Function<Material, TextureAtlasSprite> spriteGetter, BlockModel baseModel, CallbackInfoReturnable<BlockModel> callback) {
        if (baseModel.customData.hasCustomGeometry() && baseModel.customData.getCustomGeometry().getClass() == OilCoatedItemModel.class && baseModel.m_111477_("coating")) {
            String value;
            ArrayList<BlockElement> blockElements = new ArrayList<BlockElement>();
            for (int i = 0; i < ItemModelGenerator.f_111635_.size() && !baseModel.m_111477_(value = (String)ItemModelGenerator.f_111635_.get(i)); ++i) {
                Material material = baseModel.m_111480_(value);
                SpriteContents sprite = spriteGetter.apply(material).m_245424_();
                if (value.equals("coating")) continue;
                blockElements.addAll(this.m_111638_(i, value, sprite));
            }
            HashMap<String, Either> textureMap = new HashMap<String, Either>(baseModel.f_111417_);
            textureMap.put("particle", baseModel.m_111477_("particle") ? Either.left((Object)baseModel.m_111480_("particle")) : (Either)textureMap.get("layer0"));
            BlockModel resultModel = new BlockModel(null, blockElements, textureMap, Boolean.valueOf(false), baseModel.m_111479_(), baseModel.m_111491_(), baseModel.m_111484_());
            resultModel.customData.copyFrom(baseModel.customData);
            resultModel.customData.setGui3d(false);
            callback.setReturnValue((Object)resultModel);
        }
    }

    @Shadow
    public List<BlockElement> m_111638_(int index, String name, SpriteContents sprite) {
        throw new IllegalStateException("Mixin failed to shadow the \"ItemModelGenerator.processFrames(...)\" method!");
    }
}

