/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.client.models.block_entity.ClassicStargateModel;
import net.povstalec.sgjourney.client.render.block_entity.AbstractStargateRenderer;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClassicStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public class ClassicStargateRenderer
extends AbstractStargateRenderer<ClassicStargateEntity, ClassicStargateVariant> {
    protected final ClassicStargateModel stargateModel = new ClassicStargateModel();

    public ClassicStargateRenderer(BlockEntityRendererProvider.Context context) {
        super(context, 0.25f, true, 84.0f);
    }

    @Override
    protected ClassicStargateVariant getClientVariant(ClassicStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            if (stargateVariant.get().isFound()) {
                return ClientStargateVariants.getClassicStargateVariant(stargateVariant.get().clientVariant());
            }
            if (!stargateVariant.get().isMissing()) {
                stargateVariant.get().handleLocation(ClientStargateVariants.hasClassicStargateVariant(stargateVariant.get().clientVariant()));
            }
        }
        return ClientStargateVariants.getClassicStargateVariant(stargate.defaultVariant());
    }

    public void render(ClassicStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        ClassicStargateVariant stargateVariant = this.getClientVariant(stargate);
        BlockState blockstate = stargate.m_58900_();
        float facing = ((Direction)blockstate.m_61143_((Property)ClassicStargateBlock.FACING)).m_122435_();
        Vec3 center = stargate.getRelativeCenter();
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
        this.renderCover(stargate, stack, source, combinedLight, combinedOverlay);
        stack.m_85836_();
        stack.m_85837_(center.m_7096_(), center.m_7098_(), center.m_7094_());
        stack.m_252781_(Axis.f_252436_.m_252977_(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        this.stargateModel.setRotation(stargate.getRotationDegrees(partialTick));
        this.stargateModel.renderStargate(stargate, stargateVariant, partialTick, stack, source, combinedLight, combinedOverlay);
        this.irisModel.renderIris(stargate, stack, source, combinedLight, combinedOverlay, stargate.irisInfo().getIrisProgress(partialTick));
        this.renderWormhole(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
        stack.m_85849_();
    }
}

