/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class ToolPartLootEntry
extends LootPoolSingletonContainer {
    private final TagKey<Item> tag;
    private final RandomMaterial material;

    protected ToolPartLootEntry(TagKey<Item> tag, RandomMaterial material, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.tag = tag;
        this.material = material;
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)TinkerToolParts.toolPartLootEntry.get();
    }

    protected void m_6948_(Consumer<ItemStack> consumer, LootContext context) {
        MaterialVariantId material;
        RandomSource random;
        IToolPart choice;
        List options = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_257033_, this.tag).flatMap(item -> {
            Stream<Object> stream;
            if (item instanceof IToolPart) {
                IToolPart mat = (IToolPart)item;
                stream = Stream.of(mat);
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).toList();
        if (!options.isEmpty() && (choice = (IToolPart)options.get((random = context.m_230907_()).m_188503_(options.size()))).canUseMaterial((material = this.material.getMaterial(choice.getStatType(), random)).getId())) {
            consumer.accept(choice.withMaterial(material));
        }
    }

    public static LootPoolSingletonContainer.Builder<?> entry(TagKey<Item> tag, RandomMaterial material) {
        return ToolPartLootEntry.m_79687_((weight, quality, conditions, functions) -> new ToolPartLootEntry(tag, material, weight, quality, conditions, functions));
    }

    public static LootPoolSingletonContainer.Builder<?> fixed(TagKey<Item> tag, MaterialVariantId material) {
        return ToolPartLootEntry.entry(tag, RandomMaterial.fixed(material));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<ToolPartLootEntry> {
        public void serializeCustom(JsonObject json, ToolPartLootEntry object, JsonSerializationContext conditions) {
            super.m_7219_(json, (LootPoolSingletonContainer)object, conditions);
            json.addProperty("tag", object.tag.f_203868_().toString());
            json.add("material", RandomMaterial.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.material));
        }

        protected ToolPartLootEntry deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            TagKey tag = (TagKey)Loadables.ITEM_TAG.getIfPresent(json, "tag");
            RandomMaterial material = (RandomMaterial)RandomMaterial.LOADER.getIfPresent(json, "material");
            return new ToolPartLootEntry((TagKey<Item>)tag, material, weight, quality, conditions, functions);
        }
    }
}

