/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.packet.types.client;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.packet.types.client.ClientBarrierMethods;

public class PacketSetClientRadioactiveBlocks {
    public static final StreamCodec<FriendlyByteBuf, PacketSetClientRadioactiveBlocks> CODEC = new StreamCodec<FriendlyByteBuf, PacketSetClientRadioactiveBlocks>(){

        @Override
        public PacketSetClientRadioactiveBlocks decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            HashMap<Block, RadioactiveObject> values = new HashMap<Block, RadioactiveObject>();
            for (int i = 0; i < count; ++i) {
                values.put(((BlockItem)StreamCodec.ITEM_STACK.decode(buf).m_41720_()).m_40614_(), RadioactiveObject.STREAM_CODEC.decode((ByteBuf)buf));
            }
            return new PacketSetClientRadioactiveBlocks(values);
        }

        @Override
        public void encode(FriendlyByteBuf buf, PacketSetClientRadioactiveBlocks packet) {
            buf.writeInt(packet.blocks.size());
            packet.blocks.forEach((block, value) -> {
                StreamCodec.ITEM_STACK.encode(buf, new ItemStack((ItemLike)block));
                RadioactiveObject.STREAM_CODEC.encode((ByteBuf)buf, (RadioactiveObject)value);
            });
        }
    };
    private final HashMap<Block, RadioactiveObject> blocks;

    public PacketSetClientRadioactiveBlocks(HashMap<Block, RadioactiveObject> blocks) {
        this.blocks = blocks;
    }

    public static void handle(PacketSetClientRadioactiveBlocks message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handleSetClientRadioactiveBlocks(message.blocks));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetClientRadioactiveBlocks packet, FriendlyByteBuf buf) {
        CODEC.encode(buf, packet);
    }

    public static PacketSetClientRadioactiveBlocks decode(FriendlyByteBuf buf) {
        return CODEC.decode(buf);
    }
}

