/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.fluid2gas;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import voltaic.api.codec.StreamCodec;
import voltaic.api.gas.GasStack;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.VoltaicRecipeSerializer;
import voltaic.common.recipe.categories.fluid2gas.Fluid2GasRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.utilities.CodecUtils;

public class Fluid2GasRecipeSerializer<T extends Fluid2GasRecipe>
extends VoltaicRecipeSerializer<T> {
    private final Fluid2GasRecipe.Factory<T> factory;

    public Fluid2GasRecipeSerializer(Fluid2GasRecipe.Factory<T> factory) {
        super(CodecUtils.composite(StreamCodec.RESOURCE_LOCATION, VoltaicRecipe::m_6423_, FluidIngredient.LIST_STREAM_CODEC, Fluid2GasRecipe::getFluidIngredients, GasStack.STREAM_CODEC, Fluid2GasRecipe::getGasRecipeOutput, StreamCodec.DOUBLE, VoltaicRecipe::getXp, StreamCodec.INT, VoltaicRecipe::getTicks, StreamCodec.DOUBLE, VoltaicRecipe::getUsagePerTick, ProbableItem.LIST_STREAM_CODEC, VoltaicRecipe::getItemBiproducts, ProbableFluid.LIST_STREAM_CODEC, VoltaicRecipe::getFluidBiproducts, ProbableGas.LIST_STREAM_CODEC, VoltaicRecipe::getGasBiproducts, factory::create));
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject recipeJson) {
        List<FluidIngredient> inputs = Fluid2GasRecipeSerializer.getFluidIngredients(recipeId, recipeJson);
        GasStack output = Fluid2GasRecipeSerializer.getGasOutput(recipeId, recipeJson);
        double experience = Fluid2GasRecipeSerializer.getExperience(recipeJson);
        int ticks = Fluid2GasRecipeSerializer.getTicks(recipeId, recipeJson);
        double usagePerTick = Fluid2GasRecipeSerializer.getUsagePerTick(recipeId, recipeJson);
        List<ProbableItem> itemBi = Fluid2GasRecipeSerializer.getItemBiproducts(recipeId, recipeJson);
        List<ProbableFluid> fluidBi = Fluid2GasRecipeSerializer.getFluidBiproducts(recipeId, recipeJson);
        List<ProbableGas> gasBi = Fluid2GasRecipeSerializer.getGasBiproducts(recipeId, recipeJson);
        return this.factory.create(recipeId, inputs, output, experience, ticks, usagePerTick, itemBi, fluidBi, gasBi);
    }
}

