/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.recipeutils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import voltaic.api.codec.StreamCodec;

public class CountableIngredient
extends Ingredient {
    public static final Codec<CountableIngredient> CODEC_DIRECT_ITEM = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(instance0 -> instance0.item), (App)Codec.INT.fieldOf("count").forGetter(instance0 -> instance0.stackSize)).apply((Applicative)instance, (item, amount) -> new CountableIngredient(new ItemStack((ItemLike)item, amount.intValue()))));
    public static final Codec<CountableIngredient> CODEC_TAGGED_ITEM = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).fieldOf("tag").forGetter(instance0 -> instance0.tag), (App)Codec.INT.fieldOf("count").forGetter(instance0 -> instance0.stackSize)).apply((Applicative)instance, (tag, count) -> new CountableIngredient((TagKey<Item>)tag, (int)count)));
    public static final Codec<CountableIngredient> CODEC = Codec.either(CODEC_TAGGED_ITEM, CODEC_DIRECT_ITEM).xmap(either -> (CountableIngredient)((Object)((Object)either.map(tag -> tag, item -> item))), value -> {
        if (value.tag != null) {
            return Either.left((Object)value);
        }
        if (value.ingredient != null) {
            return Either.right((Object)value);
        }
        throw new UnsupportedOperationException("The Countable Ingredient neither has a tag nor a direct item value defined!");
    });
    public static final Codec<List<CountableIngredient>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<FriendlyByteBuf, CountableIngredient> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, CountableIngredient>(){

        @Override
        public void encode(FriendlyByteBuf buffer, CountableIngredient value) {
            buffer.writeBoolean(value.item == null);
            if (value.item == null) {
                StreamCodec.RESOURCE_LOCATION.encode((ByteBuf)buffer, value.tag.f_203868_());
                StreamCodec.INT.encode((ByteBuf)buffer, value.stackSize);
            } else {
                StreamCodec.ITEM_STACK.encode(buffer, new ItemStack((ItemLike)value.item, value.stackSize));
            }
        }

        @Override
        public CountableIngredient decode(FriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                return new CountableIngredient((TagKey<Item>)ItemTags.create((ResourceLocation)StreamCodec.RESOURCE_LOCATION.decode((ByteBuf)buffer)), StreamCodec.INT.decode((ByteBuf)buffer));
            }
            return new CountableIngredient(StreamCodec.ITEM_STACK.decode(buffer));
        }
    };
    public static final StreamCodec<FriendlyByteBuf, List<CountableIngredient>> LIST_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, List<CountableIngredient>>(){

        @Override
        public void encode(FriendlyByteBuf buf, List<CountableIngredient> ings) {
            buf.writeInt(ings.size());
            for (CountableIngredient ing : ings) {
                STREAM_CODEC.encode(buf, ing);
            }
        }

        @Override
        public List<CountableIngredient> decode(FriendlyByteBuf buf) {
            int length = buf.readInt();
            ArrayList<CountableIngredient> ings = new ArrayList<CountableIngredient>();
            for (int i = 0; i < length; ++i) {
                ings.add(STREAM_CODEC.decode(buf));
            }
            return ings;
        }
    };
    private final int stackSize;
    private final Ingredient ingredient;
    @Nullable
    private TagKey<Item> tag;
    @Nullable
    private Item item;
    @Nullable
    private ItemStack[] countedItems;

    public CountableIngredient(ItemStack stack) {
        super(Stream.empty());
        this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        this.item = stack.m_41720_();
        this.stackSize = stack.m_41613_();
    }

    public CountableIngredient(TagKey<Item> tag, int stackSize) {
        super(Stream.empty());
        this.ingredient = Ingredient.m_204132_(tag);
        this.tag = tag;
        this.stackSize = stackSize;
    }

    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack) && this.stackSize <= stack.m_41613_();
    }

    public ItemStack[] m_43908_() {
        if (this.countedItems == null) {
            ItemStack[] items;
            for (ItemStack item : items = this.ingredient.m_43908_()) {
                item.m_41764_(this.stackSize);
            }
            this.countedItems = items;
        }
        return this.countedItems;
    }

    public ItemStack[] getItemsArray() {
        if (this.countedItems == null) {
            ItemStack[] items;
            for (ItemStack item : items = this.ingredient.m_43908_()) {
                item.m_41764_(this.stackSize);
            }
            this.countedItems = items;
        }
        return this.countedItems;
    }

    public boolean isSimple() {
        return false;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public String toString() {
        return this.getItemsArray().length == 0 ? "empty" : this.getItemsArray()[0].toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CountableIngredient) {
            CountableIngredient otherIng = (CountableIngredient)((Object)obj);
            return otherIng.stackSize == this.stackSize && this.ingredient.equals(otherIng.ingredient);
        }
        return false;
    }
}

