/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.recipecategories.fluid2gas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.common.recipe.categories.fluid2gas.Fluid2GasRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public abstract class Fluid2GasRecipeCategory<T extends Fluid2GasRecipe>
extends AbstractRecipeCategory<T> {
    public Fluid2GasRecipeCategory(IGuiHelper guiHelper, Component title, ItemStack inputMachine, BackgroundObject wrapper, RecipeType<T> recipeType, int animationTime) {
        super(guiHelper, title, inputMachine, wrapper, recipeType, animationTime);
    }

    @Override
    public List<List<FluidStack>> getFluidInputs(Fluid2GasRecipe recipe) {
        ArrayList<List<FluidStack>> ingredients = new ArrayList<List<FluidStack>>();
        for (FluidIngredient ing : recipe.getFluidIngredients()) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (FluidStack stack : ing.getMatchingFluids()) {
                if (BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid()).toString().toLowerCase(Locale.ROOT).contains("flow")) continue;
                fluids.add(stack);
            }
            ingredients.add(fluids);
        }
        return ingredients;
    }

    @Override
    public List<List<ItemStack>> getItemInputs(Fluid2GasRecipe recipe) {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        for (FluidIngredient ing : recipe.getFluidIngredients()) {
            ArrayList<ItemStack> buckets = new ArrayList<ItemStack>();
            for (FluidStack stack : ing.getMatchingFluids()) {
                ItemStack bucket = new ItemStack((ItemLike)stack.getFluid().m_6859_(), 1);
                IFluidHandlerItem handler = (IFluidHandlerItem)bucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
                if (handler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                    handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    bucket = handler.getContainer();
                }
                buckets.add(bucket);
            }
            ingredients.add(buckets);
        }
        return ingredients;
    }

    @Override
    public List<ItemStack> getItemOutputs(Fluid2GasRecipe recipe) {
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ItemStack bucket = new ItemStack((ItemLike)recipe.getGasRecipeOutput().getGas().getContainer(), 1);
        IGasHandlerItem outputHandler = (IGasHandlerItem)bucket.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM);
        outputHandler.fill(recipe.getGasRecipeOutput(), GasAction.EXECUTE);
        if (outputHandler != CapabilityUtils.EMPTY_GAS_ITEM) {
            outputHandler.fill(recipe.getGasRecipeOutput(), GasAction.EXECUTE);
            bucket = outputHandler.getContainer();
            outputItems.add(bucket);
        }
        outputItems.add(bucket);
        if (recipe.hasGasBiproducts()) {
            for (ProbableGas gas : recipe.getGasBiproducts()) {
                ItemStack temp = new ItemStack((ItemLike)gas.getFullStack().getGas().getContainer());
                IGasHandlerItem handler = (IGasHandlerItem)temp.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM);
                if (handler == CapabilityUtils.EMPTY_GAS_ITEM) continue;
                handler.fill(gas.getFullStack(), GasAction.EXECUTE);
                temp = handler.getContainer();
                outputItems.add(temp);
            }
        }
        return outputItems;
    }

    @Override
    public List<GasStack> getGasOutputs(Fluid2GasRecipe recipe) {
        ArrayList<GasStack> outputs = new ArrayList<GasStack>();
        outputs.add(recipe.getGasRecipeOutput());
        if (recipe.hasGasBiproducts()) {
            outputs.addAll(Arrays.asList(recipe.getFullGasBiStacks()));
        }
        return outputs;
    }
}

