/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.recipecategories.item2item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipe;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.prefab.utilities.CapabilityUtils;

public abstract class Item2ItemRecipeCategory<T extends Item2ItemRecipe>
extends AbstractRecipeCategory<T> {
    public Item2ItemRecipeCategory(IGuiHelper guiHelper, Component title, ItemStack inputMachine, BackgroundObject bWrap, RecipeType<T> recipeType, int animTime) {
        super(guiHelper, title, inputMachine, bWrap, recipeType, animTime);
    }

    @Override
    public List<List<ItemStack>> getItemInputs(Item2ItemRecipe recipe) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        recipe.getCountedIngredients().forEach(h -> inputs.add(Arrays.asList(h.getItemsArray())));
        return inputs;
    }

    @Override
    public List<ItemStack> getItemOutputs(Item2ItemRecipe recipe) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        outputs.add(recipe.getItemRecipeOutput());
        if (recipe.hasItemBiproducts()) {
            outputs.addAll(Arrays.asList(recipe.getFullItemBiStacks()));
        }
        if (recipe.hasFluidBiproducts()) {
            for (ProbableFluid fluid : recipe.getFluidBiproducts()) {
                ItemStack canister = new ItemStack((ItemLike)fluid.getFullStack().getFluid().m_6859_(), 1);
                IFluidHandlerItem handler = (IFluidHandlerItem)canister.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
                if (handler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                    handler.fill(fluid.getFullStack(), IFluidHandler.FluidAction.EXECUTE);
                    canister = handler.getContainer();
                }
                outputs.add(canister);
            }
        }
        return outputs;
    }
}

