/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.inventory.container;

import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.utilities.ContainerUtils;

public abstract class GenericContainer<CONTAINERTYPE>
extends AbstractContainerMenu {
    public static final SimpleContainer EMPTY = new SimpleContainer(0);
    private final CONTAINERTYPE inventory;
    private final Level world;
    private final Inventory playerinv;
    private final Player player;
    private final int slotCount;
    private int playerInvOffset = 0;
    private int nextIndex = 0;

    public int nextIndex() {
        return this.nextIndex++;
    }

    public int nextIndex(int offset) {
        this.nextIndex += offset;
        return this.nextIndex++;
    }

    public GenericContainer(MenuType<?> type, int id, Inventory playerinv, CONTAINERTYPE inventory) {
        super(type, id);
        this.validateContainer(inventory);
        this.inventory = inventory;
        this.playerinv = playerinv;
        this.player = playerinv.f_35978_;
        this.world = playerinv.f_35978_.m_9236_();
        this.addInventorySlots(inventory, playerinv);
        this.slotCount = this.f_38839_.size();
        this.addPlayerInventory(playerinv);
    }

    public void addPlayerInventory(Inventory playerinv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new SlotGeneric((Container)playerinv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + this.getPlayerInvOffset()));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new SlotGeneric((Container)playerinv, k, 8 + k * 18, 142 + this.getPlayerInvOffset()));
        }
    }

    public abstract void validateContainer(CONTAINERTYPE var1);

    public abstract void addInventorySlots(CONTAINERTYPE var1, Inventory var2);

    public void setPlayerInvOffset(int offset) {
        this.playerInvOffset = offset;
    }

    public CONTAINERTYPE getContainer() {
        return this.inventory;
    }

    public Level getLevel() {
        return this.world;
    }

    public Inventory getPlayerInventory() {
        return this.playerinv;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getAdditionalSlotCount() {
        return this.slotCount;
    }

    public int getPlayerInvOffset() {
        return this.playerInvOffset;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ContainerUtils.handleShiftClick((List<Slot>)this.f_38839_, player, index);
    }
}

