/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.item;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.utilities.object.TransferPack;

public class CapabilityForgeEnergyItem
implements IEnergyStorage {
    private final ItemStack stack;
    private final IItemElectric electric;
    private final boolean canRecieve;
    private final boolean canExtract;

    public CapabilityForgeEnergyItem(ItemStack stack, boolean canRecieve, boolean canExtract) {
        this.stack = stack;
        this.electric = (IItemElectric)stack.m_41720_();
        this.canRecieve = canRecieve;
        this.canExtract = canExtract;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return (int)this.electric.receivePower(this.stack, TransferPack.joulesVoltage(toReceive, this.electric.getElectricProperties().receive.getVoltage()), simulate).getJoules();
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return (int)this.electric.extractPower(this.stack, toExtract, simulate).getJoules();
    }

    public int getEnergyStored() {
        return (int)this.electric.getJoulesStored(this.stack);
    }

    public int getMaxEnergyStored() {
        return (int)this.electric.getMaximumCapacity(this.stack);
    }

    public boolean canExtract() {
        return this.canExtract;
    }

    public boolean canReceive() {
        return this.canRecieve;
    }
}

