/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.variant;

import net.minecraft.nbt.CompoundTag;
import voltaic.Voltaic;
import voltaic.common.packet.NetworkHandler;
import voltaic.common.packet.types.server.PacketSendUpdatePropertiesServer;
import voltaic.prefab.properties.PropertyManager;
import voltaic.prefab.properties.types.IPropertyType;

public abstract class AbstractProperty<T, PROPERTYTYPE extends IPropertyType> {
    private PropertyManager manager;
    private final PROPERTYTYPE type;
    private boolean shouldSave = true;
    private boolean shouldUpdateClient = true;
    private boolean shouldUpdateOnChange = false;
    private boolean shouldUpdateServer = true;
    private final String name;
    private boolean isDirty = true;
    protected T value;
    private int index = 0;

    public AbstractProperty(PROPERTYTYPE type, String name, T defaultValue) {
        this.type = type;
        if (name == null || name.length() == 0) {
            throw new RuntimeException("The property's name cannot be null or empty");
        }
        this.name = name;
        this.value = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldSave() {
        return this.shouldSave;
    }

    public <A extends AbstractProperty<T, PROPERTYTYPE>> A setNoSave() {
        this.shouldSave = false;
        return (A)this;
    }

    public boolean shouldUpdateClient() {
        return this.shouldUpdateClient;
    }

    public <A extends AbstractProperty<T, PROPERTYTYPE>> A setNoUpdateClient() {
        this.shouldUpdateClient = false;
        return (A)this;
    }

    public boolean shouldUpdateOnChange() {
        return this.shouldUpdateOnChange;
    }

    public <A extends AbstractProperty<T, PROPERTYTYPE>> A setShouldUpdateOnChange() {
        this.shouldUpdateOnChange = true;
        return (A)this;
    }

    public boolean shouldUpdateServer() {
        return this.shouldUpdateServer;
    }

    public <A extends AbstractProperty<T, PROPERTYTYPE>> A setNoUpdateServer() {
        this.shouldUpdateServer = false;
        return (A)this;
    }

    public PROPERTYTYPE getType() {
        return this.type;
    }

    public int index() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public PropertyManager getPropertyManager() {
        return this.manager;
    }

    public void setManager(PropertyManager manager) {
        this.manager = manager;
    }

    public void saveToTag(CompoundTag tag) {
        try {
            this.getType().writeToTag(new IPropertyType.TagWriter(this, tag));
        }
        catch (Exception e) {
            Voltaic.LOGGER.info("Catching error while saving property " + this.getName() + " from NBT. Error: " + e.getMessage());
        }
    }

    public void loadFromTag(CompoundTag tag) {
        try {
            Object data = this.getType().readFromTag(new IPropertyType.TagReader(this, tag));
            if (data != null) {
                this.value = data;
                this.onLoadedFromTag(this, this.value);
            }
        }
        catch (Exception e) {
            Voltaic.LOGGER.info("Catching error while loading property " + this.getName() + " from NBT. Error: " + e.getMessage());
        }
    }

    public abstract void onTileLoaded();

    public abstract void onLoadedFromTag(AbstractProperty<T, PROPERTYTYPE> var1, T var2);

    public T getValue() {
        return this.value;
    }

    public abstract void setValue(Object var1);

    @Deprecated(since="Be careful when you use this!")
    public void overwriteValue(T newVal) {
        this.value = newVal;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Deprecated(since="This should be used when working with arrays")
    public void forceDirtyForManager() {
        if (!this.manager.getOwner().m_58904_().m_5776_()) {
            this.manager.setDirty(this);
        } else {
            CompoundTag data = new CompoundTag();
            this.saveToTag(data);
            NetworkHandler.CHANNEL.sendToServer((Object)new PacketSendUpdatePropertiesServer(data, this.index(), this.manager.getOwner().m_58899_()));
        }
    }

    public void clean() {
        this.isDirty = false;
    }

    public void updateServer() {
        CompoundTag data = new CompoundTag();
        this.saveToTag(data);
        NetworkHandler.CHANNEL.sendToServer((Object)new PacketSendUpdatePropertiesServer(data, this.index(), this.manager.getOwner().m_58899_()));
    }
}

