/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SnapperTemptGoal
extends Goal {
    private final TargetingConditions targetingConditions;
    private final SandSnapperEntity sandSnapper;
    private final double speedModifier;
    private final float minPlayerDistance;
    @Nullable
    private Player player;
    private int cooldownTimer;
    private static final int COOLDOWN = 100;
    private final Ingredient items;

    public SnapperTemptGoal(SandSnapperEntity sandSnapper, double speedModifier, float minPlayerDistance, float maxPlayerDistance) {
        this.sandSnapper = sandSnapper;
        this.speedModifier = speedModifier;
        this.items = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get()});
        this.minPlayerDistance = minPlayerDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.targetingConditions = TargetingConditions.m_148353_().m_148355_().m_26888_(this::isHoldingTemptingItem).m_26883_((double)maxPlayerDistance);
    }

    public boolean m_8036_() {
        if (this.sandSnapper.recentlyFedTimer > 0) {
            return false;
        }
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
            return false;
        }
        this.player = this.sandSnapper.m_9236_().m_45946_(this.targetingConditions, (LivingEntity)this.sandSnapper);
        return this.player != null;
    }

    public void m_8056_() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
    }

    public void m_8037_() {
        this.sandSnapper.m_21563_().m_24960_((Entity)this.player, (float)(this.sandSnapper.m_8085_() + 20), (float)this.sandSnapper.m_8132_());
        double sqrDist = this.sandSnapper.m_20280_((Entity)this.player);
        if (sqrDist < (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            this.sandSnapper.m_21573_().m_26573_();
        } else {
            this.sandSnapper.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
        }
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8041_() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
        this.player = null;
        this.sandSnapper.m_21573_().m_26573_();
        this.cooldownTimer = SnapperTemptGoal.m_186073_((int)100);
    }

    private boolean isHoldingTemptingItem(LivingEntity livingEntity) {
        return this.items.test(livingEntity.m_21205_()) || this.items.test(livingEntity.m_21206_());
    }
}

