/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.server.storage.EnderSourceData;
import com.github.jarva.arsadditions.server.sync.SourceJarSync;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnderSourceJarTile
extends SourceJarTile
implements ITickable {
    public static String OWNER_UUID_TAG = "owner_uuid";
    private UUID owner = null;
    private boolean registered = false;

    public EnderSourceJarTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockRegistry.ENDER_SOURCE_JAR_TILE.get(), pos, state);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && !this.registered && this.getOwner() != null) {
            int source = EnderSourceData.getSource(this.f_58857_.m_7654_(), this.getOwner());
            this.setSource(source);
            SourceJarSync.addPosition(this.f_58857_, this.f_58858_);
            this.registered = true;
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.getOwner() != null) {
            tag.m_128362_(OWNER_UUID_TAG, this.getOwner());
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128403_(OWNER_UUID_TAG)) {
            this.setOwner(tag.m_128342_(OWNER_UUID_TAG));
        }
        super.m_142466_(tag);
    }

    public int getSource() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && this.getOwner() != null) {
            EnderSourceData.getSource(this.m_58904_().m_7654_(), this.getOwner());
        }
        return super.getSource();
    }

    public int setSource(int source) {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && this.getOwner() != null) {
            EnderSourceData.setSource(this.m_58904_().m_7654_(), this.getOwner(), source);
        }
        return super.setSource(source);
    }

    public boolean canAcceptSource() {
        if (this.getOwner() == null) {
            return false;
        }
        return super.canAcceptSource();
    }

    public boolean canAcceptSource(int source) {
        if (this.getOwner() == null) {
            return false;
        }
        return super.canAcceptSource(source);
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.getOwner() != null) {
            super.getTooltip(tooltip);
        }
    }
}

