/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.loot.functions;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonLootItemFunctionsRegistry;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class ExplorationScrollFunction
extends LootItemConditionalFunction {
    public static final TagKey<Structure> DEFAULT_DESTINATION = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ArsAdditions.prefix("on_explorer_warp_scroll"));
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    private final TagKey<Structure> tag;
    private final ResourceKey<Structure> resource;
    private final int searchRadius;
    private final boolean skipKnownStructures;

    protected ExplorationScrollFunction(LootItemCondition[] predicates, TagKey<Structure> tagKey, ResourceKey<Structure> resourceKey, int searchRadius, boolean skipKnownStructures) {
        super(predicates);
        this.tag = tagKey;
        this.resource = resourceKey;
        this.searchRadius = searchRadius;
        this.skipKnownStructures = skipKnownStructures;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)AddonLootItemFunctionsRegistry.EXPLORATION_SCROLL_TYPE.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (!stack.m_150930_((Item)AddonItemRegistry.EXPLORATION_WARP_SCROLL.get())) {
            return stack;
        }
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        this.saveData(stack, origin);
        if (origin == null) {
            return stack;
        }
        ServerLevel level = context.m_78952_();
        HolderSet<Structure> holderSet = this.resource != null ? LocateUtil.holderFromResource(level, this.resource) : LocateUtil.holderFromTag(level, this.tag);
        LocateUtil.locateWithState(stack, level, holderSet, BlockPos.m_274446_((Position)origin), this.searchRadius, this.skipKnownStructures);
        return stack;
    }

    private void saveData(ItemStack stack, Vec3 origin) {
        CompoundTag tag = stack.m_41784_();
        if (this.resource != null) {
            tag.m_128359_("resource", this.resource.m_135782_().toString());
        } else {
            tag.m_128359_("tag", this.tag.f_203868_().toString());
        }
        if (origin != null) {
            CompoundTag pos = new CompoundTag();
            pos.m_128347_("x", origin.m_7096_());
            pos.m_128347_("y", origin.m_7098_());
            pos.m_128347_("z", origin.m_7094_());
            tag.m_128365_("origin", (Tag)pos);
        }
        tag.m_128405_("search_radius", this.searchRadius);
        tag.m_128379_("skip_known", this.skipKnownStructures);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ExplorationScrollFunction> {
        public void serialize(JsonObject json, ExplorationScrollFunction value, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)value, serializationContext);
            if (value.resource != null) {
                json.addProperty("resource", value.resource.m_135782_().toString());
            }
            if (value.tag != DEFAULT_DESTINATION) {
                json.addProperty("tag", value.tag.f_203868_().toString());
            }
            if (value.searchRadius != 50) {
                json.addProperty("search_radius", (Number)value.searchRadius);
            }
            if (!value.skipKnownStructures) {
                json.addProperty("skip_existing_chunks", Boolean.valueOf(value.skipKnownStructures));
            }
        }

        public ExplorationScrollFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            TagKey<Structure> tagKey = Serializer.readTag(object);
            ResourceKey<Structure> resourceKey = Serializer.readResource(object);
            int i = GsonHelper.m_13824_((JsonObject)object, (String)"search_radius", (int)50);
            boolean bl = GsonHelper.m_13855_((JsonObject)object, (String)"skip_existing_chunks", (boolean)true);
            return new ExplorationScrollFunction(conditions, tagKey, resourceKey, i, bl);
        }

        private static TagKey<Structure> readTag(JsonObject jsonObject) {
            if (jsonObject.has("tag")) {
                String string = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag");
                return TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(string));
            }
            return DEFAULT_DESTINATION;
        }

        private static ResourceKey<Structure> readResource(JsonObject jsonObject) {
            if (jsonObject.has("resource")) {
                String string = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"resource");
                return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(string));
            }
            return null;
        }
    }
}

