/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.wixie;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.SingleRecipe;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class EnchantingApparatusRecipeWrapper
extends MultiRecipeWrapper {
    public static Map<Item, MultiRecipeWrapper> RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();

    public static MultiRecipeWrapper fromStack(ItemStack stack, Level level) {
        if (RECIPE_CACHE.containsKey(stack.m_41720_())) {
            return RECIPE_CACHE.get(stack.m_41720_());
        }
        EnchantingApparatusRecipeWrapper wrapper = new EnchantingApparatusRecipeWrapper();
        if (level.m_7654_() == null) {
            return wrapper;
        }
        for (Recipe recipe : level.m_7654_().m_129894_().m_44051_()) {
            if (!(recipe instanceof EnchantingApparatusRecipe)) continue;
            EnchantingApparatusRecipe apparatusRecipe = (EnchantingApparatusRecipe)recipe;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(apparatusRecipe.pedestalItems);
            ItemStack result = apparatusRecipe.result;
            if (recipe instanceof EnchantmentRecipe) {
                EnchantmentRecipe enchantmentRecipe = (EnchantmentRecipe)recipe;
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                if (!enchantments.containsKey(enchantmentRecipe.enchantment) || (Integer)enchantments.get(enchantmentRecipe.enchantment) != enchantmentRecipe.enchantLevel) {
                    continue;
                }
            } else {
                if (result.m_41720_() != stack.m_41720_()) continue;
                ingredients.add(apparatusRecipe.reagent);
            }
            wrapper.addRecipe(ingredients, result, recipe);
        }
        RECIPE_CACHE.put(stack.m_41720_(), wrapper);
        return wrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public List<ItemStack> getItemsNeeded(Map<Item, Integer> inventory, Level world, BlockPos pos, SingleRecipe recipe) {
        List otherItems;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Recipe recipe2 = recipe.iRecipe;
        if (recipe2 instanceof EnchantmentRecipe) {
            EnchantmentRecipe enchantmentRecipe = (EnchantmentRecipe)recipe2;
            BlockEntity tile = world.m_7702_(pos);
            ArrayList<FilterableItemHandler> filterables = new ArrayList<FilterableItemHandler>();
            if (!(tile instanceof WixieCauldronTile)) return null;
            WixieCauldronTile cauldronTile = (WixieCauldronTile)tile;
            if (!(world instanceof ServerLevel)) return null;
            ServerLevel serverLevel = (ServerLevel)world;
            for (BlockPos p : cauldronTile.getInventories()) {
                BlockEntity be = world.m_7702_(p);
                if (be == null) continue;
                filterables.add(InvUtil.getFilteredHandler((BlockEntity)be));
            }
            InventoryManager inventoryManager = new InventoryManager(filterables);
            SlotReference slot = inventoryManager.findItem(is -> is.m_150930_(Items.f_42517_) || enchantmentRecipe.doesReagentMatch(is, (Player)ANFakePlayer.getPlayer((ServerLevel)serverLevel)), InteractType.EXTRACT);
            if (slot.isEmpty()) {
                return null;
            }
            ItemStack found = slot.getHandler().getStackInSlot(slot.getSlot()).m_41777_();
            items.add(found);
            ItemStack output = found.m_41720_() == Items.f_42517_ ? new ItemStack((ItemLike)Items.f_42690_) : found.m_41777_();
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)output);
            enchantments.put(enchantmentRecipe.enchantment, enchantmentRecipe.enchantLevel);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)output);
            recipe.outputStack = output;
        }
        if ((otherItems = super.getItemsNeeded(inventory, world, pos, recipe)) == null) {
            return null;
        }
        items.addAll(otherItems);
        return items;
    }
}

