/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.util.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;

public record ResourceOrTag<T>(Optional<TagKey<T>> tag, Optional<ResourceKey<T>> key) {
    public static final Codec<ResourceOrTag<EntityType<?>>> ENTITY_TYPE_CODEC = ResourceOrTag.createCodec(Registries.f_256939_);
    public static final Codec<ResourceOrTag<Item>> ITEM_CODEC = ResourceOrTag.createCodec(Registries.f_256913_);
    public static final Codec<ResourceOrTag<Structure>> STRUCTURE_CODEC = ResourceOrTag.createCodec(Registries.f_256944_);

    public static <T> Codec<ResourceOrTag<T>> createCodec(ResourceKey<Registry<T>> registry) {
        return RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)registry).optionalFieldOf("tag").forGetter(rec -> rec.tag), (App)ResourceKey.m_195966_((ResourceKey)registry).optionalFieldOf("key").forGetter(rec -> rec.key)).apply((Applicative)instance, ResourceOrTag::new));
    }

    public void apply(Consumer<TagKey<T>> tagConsumer, Consumer<ResourceKey<T>> keyConsumer) {
        this.tag.ifPresent(tagConsumer);
        this.key.ifPresent(keyConsumer);
    }

    public <R> Optional<R> map(Function<TagKey<T>, R> tagConsumer, Function<ResourceKey<T>, R> keyConsumer) {
        return this.tag.map(tagConsumer).or(() -> this.key.map(keyConsumer));
    }

    public static <T> ResourceOrTag<T> tag(TagKey<T> tag) {
        return new ResourceOrTag<T>(Optional.of(tag), Optional.empty());
    }

    public static <T> ResourceOrTag<T> key(ResourceKey<T> key) {
        return new ResourceOrTag<T>(Optional.empty(), Optional.of(key));
    }

    public static ResourceOrTag<Item> item(Item item) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)item));
        return ResourceOrTag.key(key);
    }

    public static ResourceOrTag<Block> block(Block block) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)BuiltInRegistries.f_256975_.m_7981_((Object)block));
        return ResourceOrTag.key(key);
    }
}

