/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.common.glyph.EffectMark;
import com.github.jarva.arsadditions.common.glyph.MethodRecall;
import com.github.jarva.arsadditions.common.glyph.MethodRetaliate;
import com.github.jarva.arsadditions.datagen.Setup;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class GlyphDatagen
extends GlyphRecipeProvider {
    public GlyphDatagen(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        this.addRecipe((AbstractSpellPart)MethodRetaliate.INSTANCE, this.i((ItemLike)Items.f_42393_), this.i(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44972_, 3))));
        this.addRecipe((AbstractSpellPart)MethodRecall.INSTANCE, this.i((ItemLike)ItemsRegistry.CONJURATION_ESSENCE), this.i((ItemLike)Items.f_42584_), this.i((ItemLike)ItemsRegistry.SCRYER_SCROLL), this.i((ItemLike)ItemsRegistry.SCRY_CASTER));
        this.addRecipe((AbstractSpellPart)EffectMark.INSTANCE, this.i((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE), this.i((ItemLike)Items.f_42584_), this.i((ItemLike)BlockRegistry.MOB_JAR), this.i((ItemLike)RitualRegistry.getRitualItemMap().get(new ResourceLocation("ars_nouveau", RitualLib.CONTAINMENT))));
        for (GlyphRecipe recipe : this.recipes) {
            Path path = GlyphDatagen.getScribeGlyphPath(this.output, recipe.output.m_41720_());
            this.saveStable(cache, recipe.asRecipe(), path);
        }
    }

    public Ingredient i(ItemLike item) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    public Ingredient i(ItemStack item) {
        return StrictNBTIngredient.of((ItemStack)item);
    }

    public void addRecipe(AbstractSpellPart part, Ingredient ... items) {
        GlyphRecipe recipe = this.get(part);
        for (Ingredient item : items) {
            recipe.withIngredient(item);
        }
        this.recipes.add(recipe);
    }

    protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
        return pathIn.resolve("data/" + Setup.root + "/recipes/" + RegistryHelper.getRegistryName((Item)glyph).m_135815_() + ".json");
    }
}

