/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.entity.spells.EntityMagnetSpell;
import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectEvaporate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGrow;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class GlyphEvents {
    @SubscribeEvent
    public static void empowerGlyphs(EffectResolveEvent.Pre event) {
        if (!((Boolean)ConfigHandler.COMMON.EnableGlyphEmpowering.get()).booleanValue()) {
            return;
        }
        HitResult hitResult = event.rayTraceResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            GlyphEvents.empowerResolveOnBlocks(event, blockHitResult, event.resolver);
        } else {
            hitResult = event.rayTraceResult;
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                GlyphEvents.empowerResolveOnEntities(event, entityHitResult, event.resolver);
            }
        }
    }

    public static void empowerResolveOnEntities(EffectResolveEvent.Pre event, EntityHitResult entityHitResult, SpellResolver resolver) {
        MobEffectInstance mobEffectInstance;
        LivingEntity living;
        block19: {
            block18: {
                Entity entity = entityHitResult.m_82443_();
                if (!(entity instanceof LivingEntity)) break block18;
                living = (LivingEntity)entity;
                if (event.world instanceof ServerLevel) break block19;
            }
            return;
        }
        boolean hasFire = ISchoolFocus.fireCheck(resolver);
        boolean hasWater = ISchoolFocus.waterCheck(resolver);
        boolean hasEarth = ISchoolFocus.earthCheck(resolver);
        boolean hasAir = ISchoolFocus.airCheck(resolver);
        if (event.resolveEffect == EffectCut.INSTANCE && living.m_21023_((MobEffect)ModPotions.LIFE_LINK.get()) && (mobEffectInstance = living.m_21124_((MobEffect)ModPotions.LIFE_LINK.get())) instanceof EntityCarryMEI) {
            EntityCarryMEI effect = (EntityCarryMEI)mobEffectInstance;
            if (effect.getOwner() != null) {
                effect.getOwner().m_21195_((MobEffect)ModPotions.LIFE_LINK.get());
            }
            if (effect.getTarget() != null) {
                effect.getTarget().m_21195_((MobEffect)ModPotions.LIFE_LINK.get());
            }
        }
        if (event.resolveEffect == EffectIgnite.INSTANCE && hasFire) {
            living.m_147207_(new MobEffectInstance((MobEffect)ModPotions.MAGIC_FIRE.get(), 200), (Entity)living);
        }
        if (event.resolveEffect == EffectLaunch.INSTANCE && event.spellStats.getDurationMultiplier() != 0.0 && hasAir) {
            ServerPlayer serverPlayer;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 50 * (1 + (int)event.spellStats.getDurationMultiplier()), (int)event.spellStats.getAmpMultiplier() / 2));
            mobEffectInstance = event.shooter;
            if (mobEffectInstance instanceof ServerPlayer && !((serverPlayer = (ServerPlayer)mobEffectInstance) instanceof FakePlayer)) {
                ModAdvTriggers.LEVITATE.m_222618_(serverPlayer);
            }
        }
        if (event.resolveEffect == EffectFreeze.INSTANCE && event.shooter != living && hasWater) {
            Skeleton skel;
            if (living instanceof Skeleton && (skel = (Skeleton)living).m_6095_() == EntityType.f_20524_) {
                skel.m_149842_(true);
            }
            living.m_146924_(true);
            int newFrozenTicks = living.m_146888_() + (int)(60.0 * event.spellStats.getAmpMultiplier());
            living.m_146917_(newFrozenTicks);
            if (living.m_146890_() && living.m_142079_() && !living.m_21023_((MobEffect)ModPotions.FROZEN.get()) && living.f_19802_ > 10) {
                if (((Boolean)ConfigHandler.COMMON.IFRAME_SKIP.get()).booleanValue()) {
                    living.f_19802_ = 0;
                }
                living.m_147215_(new MobEffectInstance((MobEffect)ModPotions.FROZEN.get(), 10, 0, false, false, false), (Entity)living);
            }
        }
        if (event.resolveEffect == EffectGrow.INSTANCE && living.m_6336_() == MobType.f_21641_ && hasEarth && event.shooter instanceof Player) {
            ((IDamageEffect)event.resolveEffect).attemptDamage(event.world, event.shooter, event.spellStats, event.context, event.resolver, (Entity)living, event.world.m_269111_().m_269425_(), (float)(3.0 + 2.0 * event.spellStats.getAmpMultiplier()));
            if (living.m_21224_() && event.world.m_213780_().m_188503_(100) < 20) {
                BlockPos feet = living.m_20097_();
                BlockState underfoot = living.m_9236_().m_8055_(feet);
                if ((underfoot.m_60734_() == Blocks.f_152544_ || underfoot.m_204336_(BlockTags.f_144274_) || underfoot.m_204336_(BlockTags.f_13035_)) && event.world.m_8055_(feet.m_7494_()).m_60795_()) {
                    ServerPlayer serverPlayer;
                    living.m_9236_().m_46597_(feet.m_7494_(), ((Block)ModItems.GROUND_BLOSSOM.get()).m_49966_());
                    LivingEntity livingEntity = event.shooter;
                    if (livingEntity instanceof ServerPlayer && !((serverPlayer = (ServerPlayer)livingEntity) instanceof FakePlayer)) {
                        ModAdvTriggers.BLOSSOM.m_222618_(serverPlayer);
                    }
                }
            }
        }
        if (event.resolveEffect == EffectGravity.INSTANCE && event.spellStats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE) && hasEarth) {
            EntityMagnetSpell.createMagnet(event.world, event.shooter, event.spellStats, event.context, event.rayTraceResult.m_82450_());
            event.setCanceled(true);
        }
    }

    public static void empowerResolveOnBlocks(EffectResolveEvent.Pre event, BlockHitResult blockHitResult, SpellResolver resolver) {
        LivingEntity livingEntity;
        boolean hasFire = ISchoolFocus.fireCheck(resolver);
        boolean hasWater = ISchoolFocus.waterCheck(resolver);
        boolean hasEarth = ISchoolFocus.earthCheck(resolver);
        if (event.resolveEffect == EffectConjureWater.INSTANCE && hasWater && GlyphEffectUtil.hasFollowingEffect(event.context, (AbstractEffect)EffectFreeze.INSTANCE)) {
            GlyphEffectUtil.placeBlocks(blockHitResult, event.world, event.shooter, event.spellStats, event.context, new SpellResolver(event.context), Blocks.f_50126_.m_49966_());
            event.setCanceled(true);
        }
        if (event.resolveEffect == EffectGravity.INSTANCE && event.spellStats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE) && hasEarth) {
            EntityMagnetSpell.createMagnet(event.world, event.shooter, event.spellStats, event.context, event.rayTraceResult.m_82450_());
            event.setCanceled(true);
        }
        if (event.resolveEffect == EffectIgnite.INSTANCE && (livingEntity = event.shooter) instanceof Player) {
            Player player = (Player)livingEntity;
            int pierceBuff = event.spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
            List posList = SpellUtil.calcAOEBlocks((LivingEntity)event.shooter, (BlockPos)blockHitResult.m_82425_(), (BlockHitResult)blockHitResult, (double)event.spellStats.getAoeMultiplier(), (int)pierceBuff);
            boolean flag = hasFire && GlyphEffectUtil.hasFollowingEffect(event.context, (AbstractEffect)EffectEvaporate.INSTANCE);
            for (BlockPos pos1 : posList) {
                BlockState state = event.world.m_8055_(pos1);
                Block block = state.m_60734_();
                if (!(block instanceof IceBlock)) continue;
                IceBlock ice = (IceBlock)block;
                if (flag) {
                    event.world.m_7731_(pos1, Blocks.f_50016_.m_49966_(), 3);
                } else {
                    ice.m_6240_(event.world, player, pos1, state, null, ItemStack.f_41583_);
                }
                event.setCanceled(true);
            }
        }
    }
}

