/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.ai.pathing;

import java.util.Objects;
import mod.azure.azurelib.ai.pathing.AzurePathFinder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AzureNavigation
extends GroundPathNavigation {
    @Nullable
    protected BlockPos pathToPosition;
    static final float EPSILON = 1.0E-8f;

    public AzureNavigation(Mob entity, Level world) {
        super(entity, world);
    }

    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new WalkNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return new AzurePathFinder(this.f_26508_, maxVisitedNodes);
    }

    public void hardStop() {
        this.f_26496_ = null;
        this.pathToPosition = null;
    }

    protected void m_6804_() {
        super.m_6804_();
        for (int i = 0; i < this.f_26496_.m_77398_(); ++i) {
            Node node = this.f_26496_.m_77375_(i);
            Node node2 = i + 1 < this.f_26496_.m_77398_() ? this.f_26496_.m_77375_(i + 1) : null;
            BlockState blockState = this.f_26495_.m_8055_(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_));
            if (!blockState.m_204336_(BlockTags.f_13030_)) continue;
            this.f_26496_.m_77377_(i, node.m_77289_(node.f_77271_, node.f_77272_ + 1, node.f_77273_));
            if (node2 == null || node.f_77272_ < node2.f_77272_) continue;
            this.f_26496_.m_77377_(i + 1, node.m_77289_(node2.f_77271_, node.f_77272_ + 1, node2.f_77273_));
        }
    }

    protected void m_7636_() {
        Path path = Objects.requireNonNull(this.f_26496_);
        Vec3 entityPos = this.m_7475_();
        int pathLength = path.m_77398_();
        for (int i = path.m_77399_(); i < path.m_77398_(); ++i) {
            if ((double)path.m_77375_((int)i).f_77272_ == Math.floor(entityPos.f_82480_)) continue;
            pathLength = i;
            break;
        }
        Vec3 base = entityPos.m_82520_((double)(-this.f_26494_.m_20205_() * 0.5f), 0.0, (double)(-this.f_26494_.m_20205_() * 0.5f));
        Vec3 max = base.m_82520_((double)this.f_26494_.m_20205_(), (double)this.f_26494_.m_20206_(), (double)this.f_26494_.m_20205_());
        if (this.tryShortcut(path, new Vec3(this.f_26494_.m_20185_(), this.f_26494_.m_20186_(), this.f_26494_.m_20189_()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.f_26494_.m_20205_() * 0.5f))) {
            this.f_26494_.m_21563_().m_24964_(path.m_77380_((Entity)this.f_26494_));
            path.m_77393_(path.m_77399_() + 1);
        }
        this.m_6481_(entityPos);
    }

    public Path m_7864_(BlockPos blockPos, int i) {
        this.pathToPosition = blockPos;
        return super.m_7864_(blockPos, i);
    }

    public Path m_6570_(Entity entity, int i) {
        this.pathToPosition = entity.m_20183_();
        return super.m_6570_(entity, i);
    }

    public boolean m_5624_(Entity entity, double d) {
        Path path = this.m_6570_(entity, 0);
        if (path != null) {
            return this.m_26536_(path, d);
        }
        this.pathToPosition = entity.m_20183_();
        this.f_26497_ = d;
        return true;
    }

    public float getMinimumWidth() {
        return Math.max(this.f_26494_.m_20205_(), 1.0f);
    }

    public void m_7638_() {
        super.m_7638_();
        if (this.m_26571_()) {
            if (this.pathToPosition != null) {
                if (this.pathToPosition.m_203195_((Position)this.f_26494_.m_20182_(), (double)this.getMinimumWidth()) || this.f_26494_.m_20186_() > (double)this.pathToPosition.m_123342_() && BlockPos.m_274561_((double)this.pathToPosition.m_123341_(), (double)this.f_26494_.m_20186_(), (double)this.pathToPosition.m_123343_()).m_203195_((Position)this.f_26494_.m_20182_(), (double)this.getMinimumWidth())) {
                    this.pathToPosition = null;
                } else {
                    this.f_26494_.m_21566_().m_6849_((double)this.pathToPosition.m_123341_(), (double)this.pathToPosition.m_123342_(), (double)this.pathToPosition.m_123343_(), this.f_26497_);
                }
            }
            return;
        }
        if (this.m_26567_() != null) {
            this.f_26494_.m_21563_().m_24946_((double)this.m_26567_().m_123341_(), (double)this.m_26567_().m_123342_(), (double)this.m_26567_().m_123343_());
        }
    }

    private boolean isAt(Path path, float threshold) {
        Vec3 pathPos = path.m_77380_((Entity)this.f_26494_);
        return Mth.m_14154_((float)((float)(this.f_26494_.m_20185_() - pathPos.f_82479_))) < threshold && Mth.m_14154_((float)((float)(this.f_26494_.m_20189_() - pathPos.f_82481_))) < threshold && Math.abs(this.f_26494_.m_20186_() - pathPos.f_82480_) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.m_77399_();
        int end = Math.min(path.m_77398_(), curr + Mth.m_14167_((float)(this.f_26494_.m_20205_() * 0.5f)) + 1);
        int currY = path.m_77375_((int)curr).f_77272_;
        for (int i = curr + 1; i < end; ++i) {
            if (path.m_77375_((int)i).f_77272_ == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.m_77399_()) {
            Vec3 vec = path.m_77382_((Entity)this.f_26494_, i).m_82546_(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.m_77393_(i);
            return false;
        }
        return true;
    }

    private boolean sweep(Vec3 vec, Vec3 base, Vec3 max) {
        float t = 0.0f;
        float max_t = (float)vec.m_82553_();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = AzureNavigation.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = AzureNavigation.element(dir ? max : base, i);
            tr[i] = AzureNavigation.element(dir ? base : max, i);
            ldi[i] = AzureNavigation.leadEdgeToInt(lead, step[i]);
            tri[i] = AzureNavigation.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = Mth.m_14154_((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        do {
            int axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? 0 : 2) : (tNext[1] < tNext[2] ? 1 : 2);
            float dt = tNext[axis] - t;
            t = tNext[axis];
            int n = axis;
            ldi[n] = ldi[n] + step[axis];
            int n2 = axis;
            tNext[n2] = tNext[n2] + tDelta[axis];
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                tr[n3] = tr[n3] + dt * normed[i];
                tri[i] = AzureNavigation.trailEdgeToInt(tr[i], step[i]);
            }
            int stepx = step[0];
            int x0 = axis == 0 ? ldi[0] : tri[0];
            int x1 = ldi[0] + stepx;
            int stepy = step[1];
            int y0 = axis == 1 ? ldi[1] : tri[1];
            int y1 = ldi[1] + stepy;
            int stepz = step[2];
            int z0 = axis == 2 ? ldi[2] : tri[2];
            int z1 = ldi[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        BlockState block = this.f_26495_.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                        if (block.m_60647_((BlockGetter)this.f_26495_, (BlockPos)pos, PathComputationType.LAND)) continue;
                        return false;
                    }
                    BlockPathTypes below = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, x, y0 - 1, z, this.f_26494_);
                    if (below == BlockPathTypes.WATER || below == BlockPathTypes.LAVA || below == BlockPathTypes.OPEN) {
                        return false;
                    }
                    BlockPathTypes in = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, x, y0, z, this.f_26494_);
                    float priority = this.f_26494_.m_21439_(in);
                    if (priority < 0.0f || priority >= 8.0f) {
                        return false;
                    }
                    if (in != BlockPathTypes.DAMAGE_FIRE && in != BlockPathTypes.DANGER_FIRE && in != BlockPathTypes.DAMAGE_OTHER) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vec3 v, int i) {
        switch (i) {
            case 0: {
                return (float)v.f_82479_;
            }
            case 1: {
                return (float)v.f_82480_;
            }
            case 2: {
                return (float)v.f_82481_;
            }
        }
        return 0.0f;
    }
}

