/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModelRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzArmorRendererPipeline
extends AzRendererPipeline<ItemStack> {
    private final AzArmorModel<?> armorModel;
    private final AzArmorRenderer armorRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzArmorRendererPipeline(AzRendererConfig<ItemStack> config, AzArmorRenderer armorRenderer) {
        super(config);
        this.armorModel = new AzArmorModel(this);
        this.armorRenderer = armorRenderer;
    }

    @Override
    protected AzRendererPipelineContext<ItemStack> createContext(AzRendererPipeline<ItemStack> rendererPipeline) {
        return new AzArmorRendererPipelineContext(rendererPipeline);
    }

    @Override
    protected AzModelRenderer<ItemStack> createModelRenderer(AzLayerRenderer<ItemStack> layerRenderer) {
        return new AzArmorModelRenderer(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<ItemStack> createLayerRenderer(AzRendererConfig<ItemStack> config) {
        return new AzLayerRenderer<ItemStack>(config::renderLayers);
    }

    @Override
    protected void updateAnimatedTextureFrame(ItemStack animatable) {
        Entity currentEntity = this.context().currentEntity();
        if (currentEntity != null) {
            AnimatableTexture.setAndUpdate(this.config.textureLocation(animatable));
        }
    }

    @Override
    public void preRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        AzArmorRendererPipelineContext armorContext = (AzArmorRendererPipelineContext)context;
        HumanoidModel<?> baseModel = armorContext.baseModel();
        AzArmorBoneContext boneContext = armorContext.boneContext();
        AzArmorRendererConfig config = this.config();
        EquipmentSlot currentSlot = armorContext.currentSlot();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        ItemStack animatable = (ItemStack)armorContext.animatable();
        AzBakedModel model = this.armorRenderer.provider().provideBakedModel(animatable);
        PoseStack poseStack = armorContext.poseStack();
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.armorModel.applyBaseModel(baseModel);
        boneContext.grabRelevantBones(model, config.boneProvider());
        boneContext.applyBaseTransformations(baseModel);
        this.scaleModelForBaby(armorContext, isReRender);
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        this.scaleBoneWithModelPart(armorContext, boneContext, isReRender);
        if (AzAnimatorAccessor.getOrNull(this.context().currentEntity()) == null) {
            boneContext.applyBoneVisibilityBySlot(currentSlot);
        }
        if (config.alpha(context.animatable()) < 1.0f) {
            armorContext.setAlpha(config.alpha(context.animatable()));
            armorContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    public void scaleBoneWithModelPart(AzArmorRendererPipelineContext context, AzArmorBoneContext boneContext, boolean isReRender) {
        HumanoidModel<?> baseModel = context.baseModel();
        EquipmentSlot currentSlot = context.currentSlot();
        if (isReRender) {
            return;
        }
        switch (currentSlot) {
            case HEAD: {
                this.setBoneScale(boneContext.head, baseModel.f_102808_);
                break;
            }
            case CHEST: {
                this.setBoneScale(boneContext.leftArm, baseModel.f_102812_);
                this.setBoneScale(boneContext.rightArm, baseModel.f_102811_);
                this.setBoneScale(boneContext.body, baseModel.f_102810_);
                break;
            }
            case FEET: 
            case LEGS: {
                this.setBoneScale(boneContext.leftLeg, baseModel.f_102814_);
                this.setBoneScale(boneContext.rightLeg, baseModel.f_102813_);
            }
        }
    }

    private void setBoneScale(AzBone bone, ModelPart modelPart) {
        bone.setScaleX(modelPart.f_233553_);
        bone.setScaleY(modelPart.f_233554_);
        bone.setScaleZ(modelPart.f_233555_);
    }

    public void scaleModelForBaby(AzArmorRendererPipelineContext context, boolean isReRender) {
        AgeableMob ageableMob;
        Entity currentEntity = context.currentEntity();
        if (!(currentEntity instanceof AgeableMob) || !(ageableMob = (AgeableMob)currentEntity).m_6162_() || isReRender) {
            return;
        }
        HumanoidModel<?> baseModel = context.baseModel();
        EquipmentSlot currentSlot = context.currentSlot();
        PoseStack poseStack = context.poseStack();
        if (currentSlot == EquipmentSlot.HEAD) {
            if (baseModel.f_102007_) {
                float headScale = 1.5f / baseModel.f_102010_;
                poseStack.m_85841_(headScale, headScale, headScale);
            }
            poseStack.m_252880_(0.0f, baseModel.f_170338_ / 16.0f, baseModel.f_170339_ / 16.0f);
        } else {
            float bodyScale = 1.0f / baseModel.f_102011_;
            poseStack.m_85841_(bodyScale, bodyScale, bodyScale);
            poseStack.m_252880_(0.0f, baseModel.f_102012_ / 16.0f, 0.0f);
        }
    }

    public AzArmorModel<?> armorModel() {
        return this.armorModel;
    }

    public AzArmorRendererConfig config() {
        return (AzArmorRendererConfig)super.config();
    }

    public AzArmorRendererPipelineContext context() {
        return (AzArmorRendererPipelineContext)super.context();
    }

    public AzArmorRenderer renderer() {
        return this.armorRenderer;
    }
}

