/*
 * Decompiled with CFR 0.152.
 */
package net.cybjel.ccrecrafted.mixin;

import com.google.gson.JsonElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Unique
    private static final List<String> RECIPES_TO_REMOVE = List.of("computercraft:computer_normal", "computercraft:computer_advanced", "computercraft:computer_advanced_upgrade", "computercraft:cable", "computercraft:disk_drive", "computercraft:wired_modem", "computercraft:wireless_modem_advanced", "computercraft:pocket_computer_normal", "computercraft:pocket_computer_advanced", "computercraft:pocket_computer_advanced_upgrade", "computercraft:monitor_normal", "computercraft:monitor_advanced");

    @Inject(method={"apply*"}, at={@At(value="HEAD")})
    private void removeComputerCraftRecipes(Map<ResourceLocation, JsonElement> recipes, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = recipes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, JsonElement> entry = iterator.next();
            ResourceLocation recipeId = entry.getKey();
            if (!RECIPES_TO_REMOVE.contains(recipeId.toString())) continue;
            System.out.println("[CCRecrafted] Recipe Deleted: " + recipeId);
            iterator.remove();
        }
    }
}

