/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.assistance;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CharsetManipulator {
    private static final char[] charsetMC = new char[]{' ', '\u263a', '\u263b', '\u2665', '\u2666', '\u2663', '\u2660', '\u25cf', '\u25cb', ' ', ' ', '\u2642', '\u2640', ' ', '\u266a', '\u266c', '\u25b6', '\u25c0', '\u2195', '\u203c', '\u00b6', '\u2591', '\u25ac', '\u21a8', '\u2b06', '\u2b07', '\u27a1', '\u2b05', '\u221f', '\u29fa', '\u25b2', '\u25bc', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2592', '\u2800', '\u2801', '\u2808', '\u2809', '\u2802', '\u2803', '\u280a', '\u280b', '\u2810', '\u2811', '\u2818', '\u2819', '\u2812', '\u2813', '\u281a', '\u281b', '\u2804', '\u2805', '\u280c', '\u280d', '\u2806', '\u2807', '\u280e', '\u280f', '\u2814', '\u2815', '\u281c', '\u281d', '\u2816', '\u2817', '\u281e', '\u281f', '\u2593', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u2588', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final Pattern colorPattern = Pattern.compile("\u00a7[-a-fA-F\\d](?!.*\u00a7[-a-fA-F\\d])");

    public static MutableComponent toMCTxt(String line) {
        StringBuilder mcTxt = new StringBuilder();
        for (char c : line.toCharArray()) {
            if (c > '\u00ff') {
                mcTxt.append('?');
                continue;
            }
            if (c == '\u00df') {
                mcTxt.append('\u1e9e');
                continue;
            }
            mcTxt.append(charsetMC[c]);
        }
        return Component.m_237113_((String)mcTxt.toString());
    }

    public static String toCCTxt(String line) {
        StringBuilder ccTxt = new StringBuilder();
        for (char c : line.toCharArray()) {
            char index = CharsetManipulator.findCharIndex(c);
            ccTxt.append(index > '\u00ff' ? (char)'?' : (char)index);
        }
        return ccTxt.toString();
    }

    private static char findCharIndex(char c) {
        if (c == ' ') {
            return c;
        }
        for (int i = 0; i < charsetMC.length; ++i) {
            if (charsetMC[i] != c) continue;
            return (char)i;
        }
        return '?';
    }

    public static String[] wrap(String text, int width) {
        if (text == null || ((String)text).isEmpty()) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>();
        text = (String)text + " ";
        String initialSpaces = ((String)text).replaceAll("^(\\s*).*", "$1");
        text = ((String)text).substring(initialSpaces.length());
        String[] sentence = ((String)text).split("[\\s]");
        StringBuilder line = new StringBuilder(initialSpaces);
        int exceptions = 0;
        for (String word : sentence) {
            line.append(word).append(" ");
            if (line.length() <= width + 1) continue;
            if (word.length() >= 6 || exceptions >= 2) {
                String compiledLine = line.toString();
                lines.add(compiledLine);
                Matcher matcher = colorPattern.matcher(compiledLine);
                line = new StringBuilder((matcher.find() ? matcher.group() : "") + initialSpaces);
                continue;
            }
            ++exceptions;
        }
        if (!line.toString().replaceAll(colorPattern.pattern(), "").trim().isEmpty()) {
            lines.add(line.toString());
        }
        return lines.toArray(new String[0]);
    }
}

