/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi;

import java.util.HashMap;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.init.ParticleInit;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.PortalPlacer;
import net.kyrptonaught.customportalapi.portal.frame.FlatPortalAreaHelper;
import net.kyrptonaught.customportalapi.portal.frame.VanillaPortalAreaHelper;
import net.kyrptonaught.customportalapi.portal.linking.PortalLinkingStorage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="cpapireforged")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomPortalsMod {
    public static final String MOD_ID = "cpapireforged";
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"cpapireforged");
    public static final RegistryObject<CustomPortalBlock> portalBlock = BLOCKS.register("custom_portal_block", () -> new CustomPortalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50142_).m_60910_().m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(state -> 11)));
    public static HashMap<ResourceLocation, ResourceKey<Level>> dims = new HashMap();
    public static ResourceLocation VANILLAPORTAL_FRAMETESTER = new ResourceLocation("cpapireforged", "vanillanether");
    public static ResourceLocation FLATPORTAL_FRAMETESTER = new ResourceLocation("cpapireforged", "flat");
    public static PortalLinkingStorage portalLinkingStorage;

    public CustomPortalsMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ParticleInit.PARTICLES.register(bus);
        this.onInitialize(bus);
    }

    private void onServerStart(ServerStartedEvent event) {
        for (ResourceKey registryKey : event.getServer().m_129784_()) {
            dims.put(registryKey.m_135782_(), (ResourceKey<Level>)registryKey);
        }
        portalLinkingStorage = (PortalLinkingStorage)event.getServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(PortalLinkingStorage::fromNbt, PortalLinkingStorage::new, MOD_ID);
    }

    private void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        BlockHitResult blockHit;
        HitResult hit;
        Item item;
        Player player = event.getEntity();
        Level world = event.getLevel();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && PortalIgnitionSource.isRegisteredIgnitionSourceWith(item = stack.m_41720_()) && (hit = player.m_19907_(6.0, 1.0f, false)).m_6662_() == HitResult.Type.BLOCK && PortalPlacer.attemptPortalLight(world, (blockHit = (BlockHitResult)hit).m_82425_().m_121945_(blockHit.m_82434_()), PortalIgnitionSource.ItemUseSource(item))) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    public void onInitialize(IEventBus bus) {
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        CustomPortalApiRegistry.registerPortalFrameTester(VANILLAPORTAL_FRAMETESTER, VanillaPortalAreaHelper::new);
        CustomPortalApiRegistry.registerPortalFrameTester(FLATPORTAL_FRAMETESTER, FlatPortalAreaHelper::new);
        MinecraftForge.EVENT_BUS.addListener(this::onRightClickItem);
    }

    public static void logError(String message) {
        System.out.println("[cpapireforged]ERROR: " + message);
    }

    public static CustomPortalBlock getDefaultPortalBlock() {
        return (CustomPortalBlock)((Object)portalBlock.get());
    }

    @SubscribeEvent
    public static void onCommonStartUp(FMLCommonSetupEvent event) {
    }
}

